#ifndef UTILITY_H
#define UTILITY_H

#include <string>
#include <vector>
#include <utility>
#include "atltime.h"

typedef std::pair<bool, std::vector<std::string> > FIND_RESULT;

namespace  GCMUtility
{
	const std::string GetRootFolderName(const std::string& file_title);
	int StringToInt(const std::string& in);
	const std::string IntToString(int n, int width = 0);
	const std::wstring StringToWString(const std::string& in);
	const std::string WStringToString(const std::wstring& in);
	const void PrintError();
	bool IsFile(const std::string& file_name);
	bool IsFolder(const std::string& file_name);
	const FIND_RESULT FindFile(const std::string& file_title, const std::vector<std::string> vec_extention);
	const std::string ToLower(const std::string& in);
	const std::string ToUpper(const std::string& in);
};

class GCMFolderRenamer
{
private:
	std::string m_strRootFolder;
	struct RenameTask{
		std::string m_strFrom, m_strTo;
		CTime m_TimeStamp;
		RenameTask(){}
		RenameTask(const std::string& from, const std::string& to, const CTime& time_stamp)
			: m_strFrom(from), m_strTo(to), m_TimeStamp(time_stamp){}
		bool operator==(const RenameTask& lh)const{
			return m_strFrom == lh.m_strFrom;
		}
		//ƓlĂ̂ǂƐSzEEE
	};
	std::vector<RenameTask> m_vecTask;
	bool m_bTimeStamp;
public:
	GCMFolderRenamer(const std::string& root, bool time_stamp) : m_strRootFolder(root), m_bTimeStamp(time_stamp){}
	void SetTask(const std::string& file_title, const std::string& renamed, const CTime& time_stamp);
	void StartRename();
};

class GCMCurrentDirectory
{
private:
	int m_iCurrentDrive;
	std::string m_strCurrentFolder;
public:
	GCMCurrentDirectory();
	virtual ~GCMCurrentDirectory(){
		m_strCurrentFolder.clear();
	}
	void Restore() const;
	const std::string& GetCurrentDirectory(){return m_strCurrentFolder;}
};

class GCMStopWatch{
private:
	DWORD m_iStartTime;
public:
	void Start();
	void Stop();
};

#endif
