#include "Header.h"
#include "stdafx.h"
#include <algorithm>
#include <sstream>
#include <direct.h>
#include <boost/lexical_cast.hpp>
#include "Utility.h"

using namespace std;

const string GCMUtility::GetRootFolderName(const string& file_title)
{
	wstring work = StringToWString(file_title);
	if (work.find_last_of(L"\\") == 0){
		return file_title;
	}
	work.erase(work.find_last_of(L"\\"));
	return WStringToString(work);
	/*
	string res;
	CFileFind finder;
	BOOL working = finder.FindFile((file_title + "*").c_str());

	while (working){
		working = finder.FindNextFile();
		
		if (finder.IsDots())
			continue;

		res = (LPCTSTR)finder.GetRoot();
	}
    finder.Close();
	return res;
	*/
}

int GCMUtility::StringToInt(const string& in)
{
	return boost::lexical_cast<int>(in);
	/*
	istringstream iss(in);
	int res;
	iss >> res;
	return res;
	*/
}

const string GCMUtility::IntToString(int n, int width)
{
	string res = boost::lexical_cast<string>(n);
	if (width > (int)res.size()){
		res.insert(res.begin(), width - (int)res.size(), '0');
	}
	return res;

	/*
	ostringstream oss;
	oss << n;
	string res(oss.str());
	if (width > (int)res.size()){
		res.insert(res.begin(), width - (int)res.size(), '0');
	}
	return res;
	*/
}

const wstring GCMUtility::StringToWString(const string& in)
{
	int size = MultiByteToWideChar(CP_ACP, 0, in.c_str(), -1, NULL, 0) + 1;
	auto_ptr<WCHAR> buffer = auto_ptr<WCHAR>(new WCHAR[size]);
	ZeroMemory(buffer.get(), size * sizeof(WCHAR));
	MultiByteToWideChar(CP_ACP, 0, in.c_str(), -1, buffer.get(), size);
	return wstring(buffer.get());
}

const string GCMUtility::WStringToString(const wstring& in)
{
	int size = WideCharToMultiByte(CP_ACP, 0, in.c_str(), -1, NULL, 0, NULL, NULL) + 1;
	auto_ptr<char> buffer = auto_ptr<char>(new char[size]);
	ZeroMemory(buffer.get(), size * sizeof(char));
	WideCharToMultiByte(CP_ACP, 0, in.c_str(), -1, buffer.get(), size, NULL, NULL);
	return string(buffer.get());
}

const void GCMUtility::PrintError()
{
	LPVOID lpMsgBuf;
	FormatMessage(FORMAT_MESSAGE_ALLOCATE_BUFFER | FORMAT_MESSAGE_FROM_SYSTEM | FORMAT_MESSAGE_IGNORE_INSERTS,
	NULL, GetLastError(), MAKELANGID(LANG_NEUTRAL, SUBLANG_DEFAULT), (LPTSTR) &lpMsgBuf, 0, NULL);
    MessageBox( NULL, (LPCTSTR)lpMsgBuf, "Error", MB_OK | MB_ICONINFORMATION );
	LocalFree( lpMsgBuf );
}

bool GCMUtility::IsFile(const string& file_name)
{
	if (file_name.find('*') != string::npos || file_name.find('?') != string::npos)
		return false;
	bool res = false;
	CFileFind finder;
	BOOL working = finder.FindFile(file_name.c_str());
	while (working){
		working = finder.FindNextFile();
		if (finder.IsDots())
			continue;
		if (finder.IsDirectory()){
			break;
		}
		res = true;
		break;
	}
    finder.Close();
	return res;
}

bool GCMUtility::IsFolder(const string& file_name)
{
	if (file_name.find('*') != string::npos || file_name.find('?') != string::npos)
		return false;
	bool res = false;
	CFileFind finder;
	BOOL working = finder.FindFile(file_name.c_str());
	while (working){
		working = finder.FindNextFile();
		if (finder.IsDots())
			continue;
		if (finder.IsDirectory()){
			res = true;
			break;
		}
		break;
	}
    finder.Close();
	return res;
}

const FIND_RESULT GCMUtility::FindFile(const string& file_title, const vector<string> vec_extention)
{
	vector<string>::const_iterator i_find = vec_extention.begin();
	vector<string> vec_file_name;
	bool found = false;
	while (i_find != vec_extention.end()){

		CFileFind finder;
		BOOL working = finder.FindFile((file_title + "." + *i_find).c_str());

		while (working){
			working = finder.FindNextFile();
			
			if (finder.IsDots() || finder.IsDirectory())
				continue;

			found = true;
			vec_file_name.push_back((LPCTSTR)finder.GetFilePath());
		}
		finder.Close();

		++i_find;
	}

	return std::make_pair(found, vec_file_name);
}

const string GCMUtility::ToLower(const string& in)
{
	string res(in);
	for (string::iterator i = res.begin(); i != res.end(); i++){
		*i = (char)tolower(*i);
	}
	return res;
}

const string GCMUtility::ToUpper(const string& in)
{
	string res(in);
	for (string::iterator i = res.begin(); i != res.end(); i++){
		*i = (char)toupper(*i);
	}
	return res;
}

//tH_̃l[
void GCMFolderRenamer::SetTask(const string& file_title, const string& renamed, const CTime& time_stamp)
{
	string from = GCMUtility::GetRootFolderName(file_title);
	if (from == m_strRootFolder){
		return;
	}
	string to = GCMUtility::GetRootFolderName(from) + "\\" + renamed;
	m_vecTask.push_back(RenameTask(from, to, time_stamp));
}

void GCMFolderRenamer::StartRename()
{
	//_u
	vector<RenameTask> vec_temp;
	vec_temp.resize(m_vecTask.size());
	vec_temp.erase(unique_copy(m_vecTask.begin(), m_vecTask.end(), vec_temp.begin()), vec_temp.end());
	vec_temp.swap(m_vecTask);
	for (vector<RenameTask>::iterator i = m_vecTask.begin(); i != m_vecTask.end(); ++i){
		if (count(vec_temp.begin(), vec_temp.end(), *i) > 1){
			wstring work = GCMUtility::StringToWString(i->m_strTo);
			vector<wstring> vec_target;
			vec_target.push_back(L" Disc");
			vec_target.push_back(L"@Disc");
			vec_target.push_back(L" c");
			vec_target.push_back(L"@c");
			for (vector<wstring>::iterator i_disc = vec_target.begin(); i_disc != vec_target.end(); ++i_disc){
				size_t index = work.find(*i_disc);
				if (index != wstring::npos){
					work.erase(index, 6);
					break;
				}
			}
			i->m_strTo = GCMUtility::WStringToString(work);
		}
	}

	//l[Jn
	for (vector<RenameTask>::iterator i = m_vecTask.begin(); i != m_vecTask.end(); ++i){
		if (m_strRootFolder != i->m_strFrom){
			MoveFile(i->m_strFrom.c_str(), i->m_strTo.c_str());
		}
	}
	if (m_bTimeStamp){
		for (vector<RenameTask>::iterator i = m_vecTask.begin(); i != m_vecTask.end(); ++i){
			if (m_strRootFolder != i->m_strFrom){
				HANDLE handle = CreateFile(i->m_strTo.c_str(), GENERIC_READ | GENERIC_WRITE, FILE_SHARE_READ | FILE_SHARE_DELETE, NULL, OPEN_EXISTING, FILE_FLAG_BACKUP_SEMANTICS, NULL);
				if (handle == NULL){
					continue;
				}
				CTime time_temp = i->m_TimeStamp;
				int time_zone = _timezone;
				if (time_zone >= 0){
					CTimeSpan time_span(0, time_zone / (60 * 60), (time_zone / 60) % 60, time_zone % 60);
					time_temp += time_span;
				} else {
					time_zone = abs(time_zone);
					CTimeSpan time_span(0, time_zone / (60 * 60), (time_zone / 60) % 60, time_zone % 60);
					time_temp -= time_span;
				}
				SYSTEMTIME system_time;
				time_temp.GetAsSystemTime(system_time);
				FILETIME file_time;
				SystemTimeToFileTime(&system_time, &file_time);
				SetFileTime(handle, &file_time, &file_time, &file_time);
				CloseHandle(handle);
			}
		}
	}
}

//݂̃fBNgۑ
GCMCurrentDirectory::GCMCurrentDirectory(){
	m_iCurrentDrive = _getdrive();
	char folder[MAX_PATH];
	ZeroMemory(&folder, MAX_PATH);
	::GetCurrentDirectory(MAX_PATH, folder);
	m_strCurrentFolder = folder;
}

void GCMCurrentDirectory::Restore() const{
	_chdrive(m_iCurrentDrive);
	::SetCurrentDirectory(m_strCurrentFolder.c_str());
}

//XgbvEHb`
void GCMStopWatch::Start()
{
	m_iStartTime = GetTickCount();
}

void GCMStopWatch::Stop()
{
	DWORD passed_time = GetTickCount() - m_iStartTime;
	ostringstream oss;
	oss << "passed time : " << (int)passed_time << " ms";
	AfxMessageBox(oss.str().c_str(), MB_OK | MB_SYSTEMMODAL | MB_ICONEXCLAMATION, 0);
}

