#include "Header.h"
#include "stdafx.h"
#include <fstream>
#include "Utility.h"
#include "OutputText.h"

using namespace std;

GCMOutputText::GCMOutputText(const string& file_name)
{
	m_strFileName = file_name;
}

void GCMOutputText::Insert(const string& str)
{
	m_vecText.push_back(str);
}

void GCMOutputText::Output()const
{
	ofstream ofs;
	ofs.open(m_strFileName.c_str(), ios_base::app);
	vector<string>::const_iterator i = m_vecText.begin();
	while (i != m_vecText.end()){
		ofs << *i++ << endl;
	}
}

const string GCMRenameBatch::RenameBatchFileName("RenameBatch.bat");
GCMRenameBatch::GCMRenameBatch() : GCMOutputText(RenameBatchFileName)
{
}

void GCMRenameBatch::Insert(const string& file_path_title, const string& to)
{
	string root = GCMUtility::GetRootFolderName(file_path_title + ".*");
	string from = file_path_title.substr(root.size() + 1);
	if (from != to){
		string out = "\"" + from + ".*\" \"" + to + ".*\"";
		GCMOutputText::Insert(out);
	}
}
