#ifndef LETTER_WIDTH_H
#define LETTER_WIDTH_H

#include <string>

struct GCMConfigStructLetterWidth
{
	bool katakata, digit, alpha, mark, space;
	GCMConfigStructLetterWidth(){
		katakata = digit = alpha = mark = space = false;
	}
};

class GCMLetterWidth
{
private:
	bool m_bKatakana, m_bDigit, m_bAlphabet, m_bMark, m_bSpace;
	enum LETTER_TYPE {
		LETTER_KATAKANA,
		LETTER_DIGIT,
		LETTER_ALPHABET,
		LETTER_SPACE,
		LETTER_MARK,
		LETTER_UNKNOWN
	};
	bool IsNotUseMark(int c)const;
	LETTER_TYPE GetType(int c)const;
	const std::wstring ChangeLetter(int c)const;
	const std::wstring ChangeLetterWidth(int c, bool to_full)const;
	const std::string ChangeStringToLetterFull(const std::string& in)const;
	static const std::wstring strNotUseMark;
public:
	GCMLetterWidth(const GCMConfigStructLetterWidth& config);
	const std::string ChangeString(const std::string& in)const;
};

#endif
