#include "Header.h"
#include "stdafx.h"
#include "Utility.h"
#include "LetterWidth.h"

using namespace std;

const wstring GCMLetterWidth::strNotUseMark(L"^FHhb");

GCMLetterWidth::GCMLetterWidth(const GCMConfigStructLetterWidth& config)
{
	m_bKatakana = config.katakata;
	m_bDigit = config.digit;
	m_bAlphabet = config.alpha;
	m_bSpace = config.space;
	m_bMark = config.mark;
}

const string GCMLetterWidth::ChangeString(const string& in)const
{
	string work1(in);
	string disc_name;
	size_t index;
	if ((index = work1.find("Disc")) != string::npos){
		disc_name = work1.substr(index);
		work1.erase(index);
	}

	wstring work2(GCMUtility::StringToWString(ChangeStringToLetterFull(work1)));
	wstring res;
	for (wstring::iterator i = work2.begin(); i != work2.end(); ++i){
		res += ChangeLetter((int)*i);
	}
	return GCMUtility::WStringToString(res) + disc_name;
}

bool GCMLetterWidth::IsNotUseMark(int c)const
{
	return strNotUseMark.find((wchar_t)c) != wstring::npos;
}

GCMLetterWidth::LETTER_TYPE GCMLetterWidth::GetType(int c)const
{
	if (iswdigit((wint_t)c)){
		return LETTER_DIGIT;
	} else if (L'@' <= (wchar_t)c && (wchar_t)c <= L''){
		return LETTER_KATAKANA;
	} else if (iswpunct((wint_t)c)){
		return LETTER_MARK;
	} else if (iswspace((wint_t)c)){
		return LETTER_SPACE;
	} else if (iswalpha((wint_t)c)){
		return LETTER_ALPHABET;
	}
	return LETTER_UNKNOWN;
}

const wstring GCMLetterWidth::ChangeLetter(int c)const
{
	wstring res(1, (wchar_t)c);
	switch (GetType(c)){
		case LETTER_DIGIT:
			res = ChangeLetterWidth(c, m_bDigit);
			break;
		case LETTER_ALPHABET:
			res = ChangeLetterWidth(c, m_bAlphabet);
			break;
		case LETTER_MARK:
			res = ChangeLetterWidth(c, m_bMark);
			break;
		case LETTER_SPACE:
			{
				bool space = m_bSpace;
				if (IsNotUseMark(c)){
					space = true;
				}
				res = ChangeLetterWidth(c, space);
			}
			break;
		case LETTER_KATAKANA:
			res = ChangeLetterWidth(c, m_bKatakana);
			break;
		default:
			break;
	}
	return res;
}

const wstring GCMLetterWidth::ChangeLetterWidth(int c, bool to_full)const
{
	wstring work;
	work.push_back((wchar_t)c);

	DWORD option;
	if (to_full){
		option = LCMAP_FULLWIDTH;
	} else {
		option = LCMAP_HALFWIDTH;
	}
	int size_res = LCMapStringW(MAKELCID(MAKELANGID(LANG_JAPANESE, SUBLANG_DEFAULT), SORT_DEFAULT), option,
		work.c_str(), -1, NULL, 0);
	auto_ptr<WCHAR> buffer = auto_ptr<WCHAR>(new WCHAR[size_res]);
	LCMapStringW(MAKELCID(MAKELANGID(LANG_JAPANESE, SUBLANG_DEFAULT), SORT_DEFAULT), option,
		work.c_str(), -1, buffer.get(), size_res);
	return wstring(buffer.get());
}

const string GCMLetterWidth::ChangeStringToLetterFull(const string& in)const
{
	int size_res;
	size_res = LCMapString(MAKELCID(MAKELANGID(LANG_JAPANESE, SUBLANG_DEFAULT), SORT_DEFAULT), LCMAP_FULLWIDTH,
		in.c_str(), -1, NULL, 0);
	auto_ptr<char> buffer = auto_ptr<char>(new char[size_res]);
	LCMapString(MAKELCID(MAKELANGID(LANG_JAPANESE, SUBLANG_DEFAULT), SORT_DEFAULT), LCMAP_FULLWIDTH,
		in.c_str(), -1, buffer.get(), size_res);
	return string(buffer.get());
}
