#include "Header.h"
#include <fstream>
#include <algorithm>
#include "LetterWidth.h"
#include "FileNameForm.h"
#include "HaveList.h"

using namespace std;

//GCMHaveList
void GCMHaveList::Load(const string& havelist)
{
	ifstream ifs;
	ifs.open(("log\\HaveID" + havelist + ".dat").c_str());

	string id;
	while (getline(ifs, id)){
		m_setID.insert(id);
	}
}

void GCMHaveList::Save(const GCMDatabase& database, const string& havelist) const
{
	CreateDirectory("log", NULL);

	//O
	ofstream ofs;
	ofs.open(("log\\HaveID" + havelist + ".dat").c_str());

	set<string> title;
	set<string>::const_iterator iter_id = m_setID.begin();
	GCMConfigStructLetterWidth config_letter_width;
	config_letter_width.katakata = true;
	GCMFileNameForm form("%n (%l)", config_letter_width);
	while (iter_id != m_setID.end()){
		string id = *iter_id++;
		title.insert(form.GetFormedFileName(database.GetData(id), ""));
		ofs << id << endl;
	}
	ofs.close();

	//Xg
	ofstream ofs_title;
	ofs_title.open(("Xg(" + havelist + ").txt").c_str());
	ofs_title << "f[^x[Xo^:" << database.GetNumber() << "{ :" << (int)m_setID.size() << "{" << endl;

	set<string>::iterator iter_title = title.begin();
	while (iter_title != title.end()){
		ofs_title << *iter_title++ << endl;
	}
	ofs_title.close();
	title.clear();

	//Xg
	int not_have_number = database.GetNumber() - (int)m_setID.size();
	vector<string> vec_all(database.GetAllID());
	sort(vec_all.begin(), vec_all.end());
	vector<string> vec_not;
	vec_not.reserve(not_have_number);
	set_difference(vec_all.begin(), vec_all.end(), m_setID.begin(), m_setID.end(), back_inserter(vec_not));
	vec_all.clear();
	vector<string>::iterator iter_not = vec_not.begin();
	set<string> set_not;
	while (iter_not != vec_not.end()){
		set_not.insert(form.GetFormedFileName(database.GetData(*iter_not++), ""));
	}
	ofstream ofs_not;
	ofs_not.open(("Xg(" + havelist + ").txt").c_str());
	ofs_not << "f[^x[Xo^:" << database.GetNumber() << "{ :" << not_have_number << "{" << endl;
	set<string>::iterator iter_set = set_not.begin();
	while (iter_set != set_not.end()){
		ofs_not << *iter_set++ << endl;
	}
}

void GCMHaveList::Insert(const string& id)
{
	m_setID.insert(id);
}
