// GCM_RenamerDlg.h : wb_[ t@C
//

#ifndef GCM_RENAMER_DLG_H
#define GCM_RENAMER_DLG_H

#include "afxwin.h"
#include <string>
#include <vector>
#include "afxcmn.h"
#include "GCM_Renamer.h"

//eRg[̐
#define GCM_CONTROL_COUNT_BUTTON_COMMNAD	7
#define GCM_CONTROL_COUNT_BUTTON_REF		4
#define GCM_CONTROL_COUNT_EDIT				5
#define GCM_CONTROL_COUNT_CHECK_BUTTON		12
#define GCM_CONTROL_COUNT_EXPLANATION		5
#define GCM_CONTROL_COUNT_GROUP				6
#define GCM_CONTROL_COUNT_COMBO_BOX			3
/*
`FbN{^蓖
 1:TutH_
 2:TutH_ύX
 3:ROMCRC32IDƂĈ
 4:XgǉœID͏㏑
 5:kt@Cl[
 6:J^JiSpɂ
 7:Spɂ
 8:At@xbgSpɂ
 9:󔒕Spɂ
10:LSpɂ
11:쐬𔭔ɕύX
12:ob`t@C쐬
*/

class GCMCurrentDirectory;
class GCMControl;
struct GCMConfigStructControl;
class GCMConfigFile;

// CGCM_RenamerDlg _CAO
class CGCM_RenamerDlg : public CDialog
{
// RXgNV
public:
	CGCM_RenamerDlg(CWnd* pParent = NULL);	// WRXgN^
	virtual ~CGCM_RenamerDlg();

// _CAO f[^
	enum { IDD = IDD_GCM_RENAMER_DIALOG };

	protected:
	virtual void DoDataExchange(CDataExchange* pDX);	// DDX/DDV T|[g


// 
protected:
	HICON m_hIcon;

	// ꂽAbZ[W蓖Ċ֐
	virtual BOOL OnInitDialog();
	afx_msg void OnPaint();
	afx_msg HCURSOR OnQueryDragIcon();
	virtual BOOL PreTranslateMessage(MSG *pMsg);
	DECLARE_MESSAGE_MAP()
private:
	static const std::string PresetFileHeader;
	static const std::string LanguageFileHeader;
	static const std::string GeneralSettingFileName;
	static const std::string GeneralSettingFileHeader;

	const std::string GetLoadFileNameFromWindow() const;
	const std::string GetFolderNameFromWindow() const;

	const std::string GetEditWindowText(int index) const;

	void SavePreset(const std::string& preset_name) const;
	void LoadPreset(const std::string& preset_name);
	std::string m_strCurrentPreset;
	void ReloadPresetList();

	void SaveSetting() const;
	void LoadSetting();
	void CheckDatabaseFile();

	void LoadLanguage(const std::string& language);
	void ReloadLanguageList();
	std::string m_strCurrentLanguage;
	std::auto_ptr<GCMConfigFile> m_pConfigFileLanguage;

	int GetCheckBox(int i) const;

	CButton m_btnCommand[GCM_CONTROL_COUNT_BUTTON_COMMNAD];
	CButton m_btnRef[GCM_CONTROL_COUNT_BUTTON_REF];
	CEdit m_Edit[GCM_CONTROL_COUNT_EDIT];
	CButton m_CheckButton[GCM_CONTROL_COUNT_CHECK_BUTTON];
	CStatic m_StaticExplanation[GCM_CONTROL_COUNT_EXPLANATION];
	CStatic m_StaticGroup[GCM_CONTROL_COUNT_GROUP];
	CComboBox m_ComboBox[GCM_CONTROL_COUNT_COMBO_BOX];
	CProgressCtrl m_Progress;
	CListBox m_lstPreset;
	CStatic m_StaticState;


	CToolTipCtrl m_ToolTip;
	void SetToolTips();

	std::auto_ptr<GCMControl> m_pControl;
	std::auto_ptr<GCMConfigStructControl> m_pConfigControl;
	//GCMControl m_Control;
	//GCMConfigStructControl m_ConfigControl;
	void EnumerateDaemonDrive();
	void SelectDaemonDrive(const std::string& drive);
	const std::string GetSelectedDaemonDrive()const;

	static UINT MyControllingFunctionRename(LPVOID pParam);
	static UINT MyControllingFunctionGenerateList(LPVOID pParam);

public:
	afx_msg void OnBnClickedOk();
	afx_msg void OnBnClickedCancel();
	afx_msg void OnBnClickedButtonRef1();
	afx_msg void OnBnClickedButtonRef2();
	afx_msg void OnBnClickedButtonRef3();
	afx_msg void OnBnClickedButtonRef4();
	afx_msg void OnBnClickedButtonRename();
	afx_msg void OnBnClickedButtonAdd();
	afx_msg void OnDropFiles(HDROP hDropInfo);
	afx_msg void OnBnClickedButtonPresetAdd();
	afx_msg void OnBnClickedButtonPresetDelete();
	afx_msg void OnLbnSelchangeListPreset();
	afx_msg void OnBnClickedButtonStop();
	void ChangeEnableWindow(BOOL state);
	void SetProgressBarPosition(int n);
	void SetStateText(const std::string& str);
	static const int ProgressMax;
	int GetMachineNumber()const {return m_ComboBox[0].GetCurSel();}
	const GCMConfigFile& GetLanguage(){return *m_pConfigFileLanguage;}

	std::auto_ptr<GCMCurrentDirectory> m_pCD;
	//GCMCurrentDirectory m_CD;
	afx_msg void OnCbnSelchangeLanguage();
	afx_msg void OnBnClickedButtonListGenerate();
};

#endif
