#include "Header.h"
// GCM_RenamerDlg.cpp : t@C
//

#include "stdafx.h"
#include <sstream>
#include <memory>
#include "shobjidl.h"
#include "GCM_Renamer.h"
#include "GCM_RenamerNewPresetDlg.h"
#include "Database.h"
#include "Utility.h"
#include "Control.h"
#include "ConfigFile.h"
#include "GCM_RenamerDlg.h"

using namespace std;

#ifdef _DEBUG
#define new DEBUG_NEW
#endif

#define NOT_USE_THREAD
//#undef NOT_USE_THREAD

UINT CGCM_RenamerDlg::MyControllingFunctionRename(LPVOID pParam)
{
	if (pParam == NULL)
		return 1;
	GCMConfigStructControl config_control = *(GCMConfigStructControl*)pParam;
	config_control.m_pControl->Rename(config_control);
	return 0;   // thread completed successfully
}

UINT CGCM_RenamerDlg::MyControllingFunctionGenerateList(LPVOID pParam)
{
	if (pParam == NULL)
		return 1;
	GCMConfigStructControl config_control = *(GCMConfigStructControl*)pParam;    
	config_control.m_pControl->GenerateList(config_control);
	return 0;   // thread completed successfully
}

// CGCM_RenamerDlg _CAO

const int CGCM_RenamerDlg::ProgressMax = 65536;
const string CGCM_RenamerDlg::PresetFileHeader("[GCM_Renamer vZbgt@C Ver2]");
const string CGCM_RenamerDlg::LanguageFileHeader("[GCM_Renamer language file Ver1]");
const string CGCM_RenamerDlg::GeneralSettingFileName("Setting.ini");
const string CGCM_RenamerDlg::GeneralSettingFileHeader("[GCM_Renamer ݒt@C Ver3]");

CGCM_RenamerDlg::CGCM_RenamerDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CGCM_RenamerDlg::IDD, pParent)
{
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);

	m_pCD = auto_ptr<GCMCurrentDirectory>(new GCMCurrentDirectory);
	m_pControl = auto_ptr<GCMControl>(new GCMControl);
	m_pConfigControl = auto_ptr<GCMConfigStructControl>(new GCMConfigStructControl);
	m_pConfigFileLanguage = auto_ptr<GCMConfigFile>(new GCMConfigFile);
}

CGCM_RenamerDlg::~CGCM_RenamerDlg()
{
}

void CGCM_RenamerDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);

	DDX_Control(pDX, IDC_BUTTON_RENAME, m_btnCommand[0]);
	DDX_Control(pDX, IDC_BUTTON_ADD, m_btnCommand[1]);
	DDX_Control(pDX, IDCANCEL_DUMMY, m_btnCommand[2]);
	DDX_Control(pDX, IDC_BUTTON_PRESET_ADD, m_btnCommand[3]);
	DDX_Control(pDX, IDC_BUTTON_PRESET_DELETE, m_btnCommand[4]);
	DDX_Control(pDX, IDC_BUTTON_STOP, m_btnCommand[5]);
	DDX_Control(pDX, IDC_BUTTON_LIST_GENERATE, m_btnCommand[6]);

	DDX_Control(pDX, IDC_BUTTON_REF1, m_btnRef[0]);
	DDX_Control(pDX, IDC_BUTTON_REF2, m_btnRef[1]);
	DDX_Control(pDX, IDC_BUTTON_REF3, m_btnRef[2]);
	DDX_Control(pDX, IDC_BUTTON_REF4, m_btnRef[3]);

	DDX_Control(pDX, IDC_EDIT_FOLDER, m_Edit[0]);
	DDX_Control(pDX, IDC_EDIT_FORM, m_Edit[1]);
	DDX_Control(pDX, IDC_EDIT_TITLE_LIST, m_Edit[2]);
	DDX_Control(pDX, IDC_EDIT_ADD_LIST, m_Edit[3]);
	DDX_Control(pDX, IDC_EDIT_DAEMON_PROGRAM, m_Edit[4]);

	DDX_Control(pDX, IDC_CHECK1, m_CheckButton[0]);
	DDX_Control(pDX, IDC_CHECK2, m_CheckButton[1]);
	DDX_Control(pDX, IDC_CHECK3, m_CheckButton[2]);
	DDX_Control(pDX, IDC_CHECK4, m_CheckButton[3]);
	DDX_Control(pDX, IDC_CHECK5, m_CheckButton[4]);
	DDX_Control(pDX, IDC_CHECK6, m_CheckButton[5]);
	DDX_Control(pDX, IDC_CHECK7, m_CheckButton[6]);
	DDX_Control(pDX, IDC_CHECK8, m_CheckButton[7]);
	DDX_Control(pDX, IDC_CHECK9, m_CheckButton[8]);
	DDX_Control(pDX, IDC_CHECK10, m_CheckButton[9]);
	DDX_Control(pDX, IDC_CHECK11, m_CheckButton[10]);
	DDX_Control(pDX, IDC_CHECK12, m_CheckButton[11]);

	DDX_Control(pDX, IDC_COMBO1, m_ComboBox[0]);
	DDX_Control(pDX, IDC_COMBO2, m_ComboBox[1]);
	DDX_Control(pDX, IDC_COMBO3, m_ComboBox[2]);

	DDX_Control(pDX, IDC_STATIC_EDIT1, m_StaticExplanation[0]);
	DDX_Control(pDX, IDC_STATIC_EDIT2, m_StaticExplanation[1]);
	DDX_Control(pDX, IDC_STATIC_EDIT3, m_StaticExplanation[2]);
	DDX_Control(pDX, IDC_STATIC_EDIT4, m_StaticExplanation[3]);
	DDX_Control(pDX, IDC_STATIC_EDIT5, m_StaticExplanation[4]);

	DDX_Control(pDX, IDC_STATIC_GROUP1, m_StaticGroup[0]);
	DDX_Control(pDX, IDC_STATIC_GROUP2, m_StaticGroup[1]);
	DDX_Control(pDX, IDC_STATIC_GROUP3, m_StaticGroup[2]);
	DDX_Control(pDX, IDC_STATIC_GROUP4, m_StaticGroup[3]);
	DDX_Control(pDX, IDC_STATIC_GROUP5, m_StaticGroup[4]);
	DDX_Control(pDX, IDC_STATIC_GROUP6, m_StaticGroup[5]);

	DDX_Control(pDX, IDC_PROGRESS1, m_Progress);
	DDX_Control(pDX, IDC_STATIC_STATE, m_StaticState);
	DDX_Control(pDX, IDC_LIST_PRESET, m_lstPreset);
}

BEGIN_MESSAGE_MAP(CGCM_RenamerDlg, CDialog)
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	//}}AFX_MSG_MAP
	ON_BN_CLICKED(IDOK, OnBnClickedOk)
	ON_BN_CLICKED(IDCANCEL, OnBnClickedCancel)
	ON_BN_CLICKED(IDC_BUTTON_REF1, OnBnClickedButtonRef1)
	ON_BN_CLICKED(IDC_BUTTON_REF2, OnBnClickedButtonRef2)
	ON_BN_CLICKED(IDC_BUTTON_REF3, OnBnClickedButtonRef3)
	ON_BN_CLICKED(IDC_BUTTON_REF4, OnBnClickedButtonRef4)
	ON_BN_CLICKED(IDC_BUTTON_RENAME, OnBnClickedButtonRename)
	ON_BN_CLICKED(IDC_BUTTON_ADD, OnBnClickedButtonAdd)
	ON_WM_DROPFILES()
	ON_BN_CLICKED(IDC_BUTTON_PRESET_ADD, OnBnClickedButtonPresetAdd)
	ON_BN_CLICKED(IDC_BUTTON_PRESET_DELETE, OnBnClickedButtonPresetDelete)
	ON_LBN_SELCHANGE(IDC_LIST_PRESET, OnLbnSelchangeListPreset)
	ON_BN_CLICKED(IDC_BUTTON_STOP, OnBnClickedButtonStop)
	ON_CBN_SELCHANGE(IDC_COMBO2, OnCbnSelchangeLanguage)
	ON_BN_CLICKED(IDC_BUTTON_LIST_GENERATE, OnBnClickedButtonListGenerate)
END_MESSAGE_MAP()


// CGCM_RenamerDlg bZ[W nh

BOOL CGCM_RenamerDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// ̃_CAÕACRݒ肵܂BAvP[ṼC EBhE_CAOłȂꍇA
	//  Framework ́A̐ݒIɍs܂B
	SetIcon(m_hIcon, TRUE);			// 傫ACR̐ݒ
	SetIcon(m_hIcon, FALSE);		// ACR̐ݒ

	// TODO: ɒǉ܂B
	m_Progress.SetRange32(0, ProgressMax);
	//ŌɑIꂽvZbg̓ǂݍ
	LoadSetting();
	SetToolTips();
	
	return TRUE;  // tH[JXRg[ɐݒ肵ꍇATRUE Ԃ܂B
}

// _CAOɍŏ{^ǉꍇAACR`悷邽߂
//  ̃R[hKvłBhLg/r[ fg MFC AvP[V̏ꍇA
//  ́AFramework ɂĎIɐݒ肳܂B

void CGCM_RenamerDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // `̃foCX ReLXg

		SendMessage(WM_ICONERASEBKGND, reinterpret_cast<WPARAM>(dc.GetSafeHdc()), 0);

		// NCAg̎lp`̈̒
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// ACR̕`
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

//[U[ŏEBhEhbOĂƂɕ\J[\擾邽߂ɁA
//  VXe̊֐Ăяo܂B
HCURSOR CGCM_RenamerDlg::OnQueryDragIcon()
{
	return static_cast<HCURSOR>(m_hIcon);
}

void CGCM_RenamerDlg::OnBnClickedOk()
{
	SaveSetting();
	OnOK();
}

void CGCM_RenamerDlg::OnBnClickedCancel()
{
	SaveSetting();
	OnCancel();
}

void CGCM_RenamerDlg::OnBnClickedButtonRef1()
{
	string folder_name = GetFolderNameFromWindow();
	if (!folder_name.empty()){
		m_Edit[0].SetWindowText(folder_name.c_str());
	}
}

void CGCM_RenamerDlg::OnBnClickedButtonRef2()
{
	m_Edit[2].SetWindowText(GetLoadFileNameFromWindow().c_str());
}

void CGCM_RenamerDlg::OnBnClickedButtonRef3()
{
	m_Edit[3].SetWindowText(GetLoadFileNameFromWindow().c_str());
}

void CGCM_RenamerDlg::OnBnClickedButtonRef4()
{
	m_Edit[4].SetWindowText(GetLoadFileNameFromWindow().c_str());
}

void CGCM_RenamerDlg::OnBnClickedButtonRename()
{
	//l[Jn
	SavePreset(m_strCurrentPreset);
	SaveSetting();
	m_pConfigControl->m_pRenamerDlg = this;
	m_pConfigControl->m_iMachine = m_ComboBox[0].GetCurSel();
	m_pConfigControl->m_vecEdit.clear();
	for (int i = 0; i < GCM_CONTROL_COUNT_EDIT; ++i){
		m_pConfigControl->m_vecEdit.push_back(GetEditWindowText(i));
	}
	m_pConfigControl->m_vecCheckBox.clear();
	for (int i = 0; i < GCM_CONTROL_COUNT_CHECK_BUTTON; ++i){
		m_pConfigControl->m_vecCheckBox.push_back(GetCheckBox(i));
	}
	m_pConfigControl->m_pControl = m_pControl.get();
	m_pConfigControl->m_strDaemonDrive = GetSelectedDaemonDrive();
#if defined _DEBUG && defined NOT_USE_THREAD
	m_pControl->Rename(*m_pConfigControl);
#else
	AfxBeginThread(MyControllingFunctionRename, (LPVOID)m_pConfigControl.get());
#endif
}

void CGCM_RenamerDlg::OnBnClickedButtonListGenerate()
{
	//Xg쐬Jn
	SavePreset(m_strCurrentPreset);
	SaveSetting();
	m_pConfigControl->m_pRenamerDlg = this;
	m_pConfigControl->m_iMachine = m_ComboBox[0].GetCurSel();
	m_pConfigControl->m_vecEdit.clear();
	for (int i = 0; i < GCM_CONTROL_COUNT_EDIT; ++i){
		m_pConfigControl->m_vecEdit.push_back(GetEditWindowText(i));
	}
	m_pConfigControl->m_vecCheckBox.clear();
	for (int i = 0; i < GCM_CONTROL_COUNT_CHECK_BUTTON; ++i){
		m_pConfigControl->m_vecCheckBox.push_back(GetCheckBox(i));
	}
	m_pConfigControl->m_pControl = m_pControl.get();
	m_pConfigControl->m_strDaemonDrive = GetSelectedDaemonDrive();
#if defined  _DEBUG && defined NOT_USE_THREAD
	m_pControl->GenerateList(*m_pConfigControl);
#else
	AfxBeginThread(MyControllingFunctionGenerateList, (LPVOID)m_pConfigControl.get());
#endif
}

void CGCM_RenamerDlg::OnBnClickedButtonStop()
{
	m_btnCommand[5].EnableWindow(FALSE);
	m_pControl->Stop();
}

void CGCM_RenamerDlg::OnBnClickedButtonAdd()
{
	ChangeEnableWindow(FALSE);

	string database_file(GetEditWindowText(2));
	if (!GCMUtility::IsFile(database_file)){
		string text = m_pConfigFileLanguage->Get("MessageBox", "DATABASE_NOT_FOUND");
		AfxMessageBox(text.c_str(), MB_OK | MB_SYSTEMMODAL | MB_ICONINFORMATION, 0);
		ChangeEnableWindow(TRUE);
		return;
	}
	
	string add_list(GetEditWindowText(3));
	if (!GCMUtility::IsFile(add_list)){
		string text = m_pConfigFileLanguage->Get("MessageBox", "ADD_DATABASE_NOT_FOUND");
		AfxMessageBox(text.c_str(), MB_OK | MB_SYSTEMMODAL | MB_ICONINFORMATION, 0);
		ChangeEnableWindow(TRUE);
		return;
	}

	{
		string text = m_pConfigFileLanguage->Get("State", "DATABASE_ADD");
		SetStateText(text);
	}

	GCMDatabase database;
	if (GetCheckBox(3) == BST_CHECKED){
		database.LoadAllFile(add_list);
		database.LoadAllFile(database_file);
	} else {
		database.LoadAllFile(database_file);
		database.LoadAllFile(add_list);
	}
	database.SaveAllFile(database_file);
	{
		string text = m_pConfigFileLanguage->Get("MessageBox", "ADD_COMPLETE");
		AfxMessageBox(text.c_str(), MB_OK | MB_SYSTEMMODAL | MB_ICONINFORMATION, 0);
	}
	m_Edit[3].SetWindowText("");

	{
		string text = m_pConfigFileLanguage->Get("State", "WAIT");
		SetStateText(text);
	}
	ChangeEnableWindow(TRUE);
}

const std::string CGCM_RenamerDlg::GetLoadFileNameFromWindow() const
{
	CFileDialog dialog(TRUE);
	string res;
	if (dialog.DoModal() == IDOK){
		res = dialog.GetPathName();
	}
	return res;
}

const std::string CGCM_RenamerDlg::GetFolderNameFromWindow() const
{
	string res;

	LPMALLOC pMalloc;
    /* Shell ̕W̃AP[^擾 */
    if (::SHGetMalloc(&pMalloc) == NOERROR)
    {
        BROWSEINFO bi;
        char pszBuffer[MAX_PATH];
        LPITEMIDLIST pidl;
        // BROWSEINFO \̂𖄂߂ - KvȂƂׂĖ߂B

        bi.hwndOwner = GetSafeHwnd();
		/*
		string prev_folder = GetEditWindowText(0);
		while (!GCMUtility::IsFolder(prev_folder)){
			prev_folder = GCMUtility::GetRootFolderName(prev_folder);
		}
		IShellFolder *psf;
		SHGetDesktopFolder(&psf);
		psf->ParseDisplayName(GetSafeHwnd(), NULL, (LPOLESTR)prev_folder.c_str(), NULL, &pidl, NULL);
		*/
		bi.pidlRoot = NULL;
        bi.pszDisplayName = pszBuffer;
		string text = m_pConfigFileLanguage->Get("MessageBox", "SELECT_FOLDER");
		bi.lpszTitle = _T(text.c_str());
        bi.ulFlags = BIF_DONTGOBELOWDOMAIN | BIF_RETURNFSANCESTORS | BIF_RETURNONLYFSDIRS;
        bi.lpfn = NULL;
        bi.lParam = 0;
        // ̌Ăяo_CAO {bNX\B

        if ((pidl = ::SHBrowseForFolder(&bi)) != NULL)
        {
            if (::SHGetPathFromIDList(pidl, pszBuffer))
            {
            // ̎_ŁApszBuffer ɑIꂽpXĂ */.
				res = pszBuffer;
            }
            // SHBrowseForFolder ɂĊ蓖Ăꂽ PIDL 
            pMalloc->Free(pidl);
        }
        // Shell ̃AP[^
        pMalloc->Release();
    }

	return res;
}

void CGCM_RenamerDlg::SavePreset(const string& preset_name) const
{
	m_pCD->Restore();
	GCMConfigFile file(PresetFileHeader);

	for (int i = 0; i < 2; ++i){
		CString out;
		m_Edit[i].GetWindowText(out);
		file.Set("EditBox", GCMUtility::IntToString(i), (LPCTSTR)out);
	}
	for (int i = 0; i < GCM_CONTROL_COUNT_CHECK_BUTTON; ++i){
		string key = GCMUtility::IntToString(i);
		string value = GCMUtility::IntToString(m_CheckButton[i].GetCheck());
		file.Set("CheckBox", key, value);
	}
	{
		string value = GCMUtility::IntToString(m_ComboBox[0].GetCurSel());
		file.Set("ListBox", "MACHINE", value);
	}
	string file_name = ".\\preset\\" + preset_name + ".ini";
	file.Save(file_name);
}

void CGCM_RenamerDlg::LoadPreset(const string& preset_name)
{
	m_pCD->Restore();
	string file_name = ".\\preset\\" + preset_name + ".ini";
	GCMConfigFile file(PresetFileHeader);
	file.Load(file_name);
	for (int i = 0; i < 2; ++i){
		string key = GCMUtility::IntToString(i);
		string value = file.Get("EditBox", key);
		m_Edit[i].SetWindowText(value.c_str());
	}
	for (int i = 0; i < GCM_CONTROL_COUNT_CHECK_BUTTON; ++i){
		string value = file.Get("CheckBox", GCMUtility::IntToString(i));
		int check = GCMUtility::StringToInt(value);
		m_CheckButton[i].SetCheck(check);
	}
	{
		string value = file.Get("ListBox", "MACHINE");
		int machine = GCMUtility::StringToInt(value);
		m_ComboBox[0].SetCurSel(machine);
	}
}

void CGCM_RenamerDlg::ReloadPresetList()
{
	m_pCD->Restore();
	m_lstPreset.ResetContent();
	CFileFind finder;
	BOOL working = finder.FindFile(".\\preset\\*.*");
	while (working){
		working = finder.FindNextFile();
		if (finder.IsDots())
			continue;
		if (finder.IsDirectory())
			continue;
		m_lstPreset.InsertString(-1, finder.GetFileTitle());
	}
    finder.Close();
	if (m_lstPreset.SelectString(-1, m_strCurrentPreset.c_str()) == LB_ERR){
		if (m_lstPreset.SetCurSel(0) == LB_ERR){
			return;
		}
		CString buffer;
		m_lstPreset.GetText(0, buffer);
		m_strCurrentPreset = (LPCTSTR)buffer;
	}
	LoadPreset(m_strCurrentPreset);
}

void CGCM_RenamerDlg::OnBnClickedButtonPresetAdd()
{
	GCM_RenamerNewPresetDlg preset_dlg;
	if (preset_dlg.DoModal() == IDOK){
		m_strCurrentPreset = preset_dlg.GetNewPresetName();
		SavePreset(m_strCurrentPreset);
		ReloadPresetList();
	}
}

void CGCM_RenamerDlg::OnBnClickedButtonPresetDelete()
{
	if (m_lstPreset.GetCount() == 0){
		return;
	}
	CString buffer;
	m_lstPreset.GetText(m_lstPreset.GetCurSel(), buffer);
	string current_preset = (LPCTSTR)buffer;
	string text1 = m_pConfigFileLanguage->Get("MessageBox", "PRESET_DELETE_1");
	string text2 = m_pConfigFileLanguage->Get("MessageBox", "PRESET_DELETE_2");
	if (AfxMessageBox(string(text1 + current_preset + text2).c_str(), MB_YESNO | MB_SYSTEMMODAL | MB_ICONQUESTION) == IDYES){
		DeleteFile(string(".\\preset\\" + current_preset + ".ini").c_str());
		ReloadPresetList();
	}
}

void CGCM_RenamerDlg::OnLbnSelchangeListPreset()
{
	if (m_lstPreset.GetCount() == 0){
		return;
	}
	SavePreset(m_strCurrentPreset);

	CString buffer;
	m_lstPreset.GetText(m_lstPreset.GetCurSel(), buffer);
	m_strCurrentPreset = (LPCTSTR)buffer;
	LoadPreset(m_strCurrentPreset);
}

void CGCM_RenamerDlg::SaveSetting() const
{
	m_pCD->Restore();
	SavePreset(m_strCurrentPreset);
	GCMConfigFile file(GeneralSettingFileHeader);
	for (int i = 2; i < GCM_CONTROL_COUNT_EDIT; ++i){
		CString temp;
		m_Edit[i].GetWindowText(temp);
		ostringstream oss;
		oss << "EDIT" << i;
		file.Set("General", oss.str(), (LPCTSTR)temp);
	}

	file.Set("General", "CurrentPreset", m_strCurrentPreset);
	file.Set("General", "Language", m_strCurrentLanguage);
	file.Set("General", "DaemonDrive", GetSelectedDaemonDrive());

	file.Save(GeneralSettingFileName.c_str());
}

void CGCM_RenamerDlg::LoadSetting()
{
	m_pCD->Restore();
	GCMConfigFile file(GeneralSettingFileHeader);
	file.Load(GeneralSettingFileName.c_str());
	for (int i = 2; i < GCM_CONTROL_COUNT_EDIT; ++i){
		ostringstream oss;
		oss << "EDIT" << i;
		string value = file.Get("General", oss.str());
		m_Edit[i].SetWindowText(value.c_str());
	}
	CheckDatabaseFile();

	m_strCurrentPreset = file.Get("General", "CurrentPreset");
	ReloadPresetList();

	m_strCurrentLanguage = file.Get("General", "Language");
	ReloadLanguageList();

	string daemon_drive = file.Get("General", "DaemonDrive");
	SelectDaemonDrive(daemon_drive);
}

void CGCM_RenamerDlg::CheckDatabaseFile()
{
	string file_name = GetEditWindowText(2);
	//f[^x[Xt@CĂ邩ǂH
	if (GCMUtility::IsFile(file_name)){
		return;
	}
	file_name = "";
	//f[^x[Xt@C
	CFileFind finder;
	BOOL working = finder.FindFile((m_pCD->GetCurrentDirectory() + "\\*.csv").c_str());
	while (working){
		working = finder.FindNextFile();
		if (finder.IsDots())
			continue;
		if (finder.IsDirectory()){
			continue;
		}
		file_name = finder.GetFilePath();
		break;
	}
    finder.Close();
	m_Edit[2].SetWindowText(file_name.c_str());
}

void CGCM_RenamerDlg::OnDropFiles(HDROP hDropInfo)
{
	// TODO : ɃbZ[W nh R[hǉ邩ȀĂяo܂B
	UINT uiCount = DragQueryFile(hDropInfo, 0xFFFFFFFF, NULL, 0);

	for(UINT i = 0; i < uiCount; i++){
		//t@C̒擾
		UINT uiLen = DragQueryFile(hDropInfo, i, NULL, 0);

		//t@C擾
		CString buffer;
		DragQueryFile(hDropInfo, i, buffer.GetBuffer(uiLen+1), uiLen+1);
		buffer.ReleaseBuffer();
		string file_name = buffer;

		if (GCMUtility::IsFile(file_name)){
			m_Edit[2].SetWindowText(file_name.c_str());
			continue;
		}
		if (GCMUtility::IsFolder(file_name)){
			m_Edit[0].SetWindowText(file_name.c_str());
			continue;
		}
	}

	CDialog::OnDropFiles(hDropInfo);
}

void CGCM_RenamerDlg::ChangeEnableWindow(BOOL state)
{
	for (int i = 0; i < GCM_CONTROL_COUNT_EDIT; ++i){
		m_Edit[i].EnableWindow(state);
	}
	for (int i = 0; i < GCM_CONTROL_COUNT_BUTTON_REF; ++i){
		m_btnRef[i].EnableWindow(state);
	}
	for (int i = 0; i < GCM_CONTROL_COUNT_BUTTON_COMMNAD; ++i){
		m_btnCommand[i].EnableWindow(state);
	}
	for (int i = 0; i < GCM_CONTROL_COUNT_CHECK_BUTTON; ++i){
		m_CheckButton[i].EnableWindow(state);
	}
	for (int i = 0; i < GCM_CONTROL_COUNT_COMBO_BOX; ++i){
		m_ComboBox[i].EnableWindow(state);
	}
	//~{^͕
	m_btnCommand[5].EnableWindow(!state);
	m_lstPreset.EnableWindow(state);
	//OnPaint();
}

int CGCM_RenamerDlg::GetCheckBox(int i) const
{
	return m_CheckButton[i].GetCheck();
}

const string CGCM_RenamerDlg::GetEditWindowText(int index) const
{
	CString temp;
	m_Edit[index].GetWindowText(temp);
	return string((LPCTSTR)temp);
}

void CGCM_RenamerDlg::SetToolTips()
{
	if (m_ToolTip.Create(this, TTS_ALWAYSTIP)){
		m_ToolTip.SetMaxTipWidth(300);
//		m_ToolTip.SetDelayTime(TTDT_AUTOPOP, SHRT_MAX);
//		m_ToolTip.SetDelayTime(TTDT_INITIAL, 200);
//		m_ToolTip.SetDelayTime(TTDT_RESHOW, 200);
	}

	m_ToolTip.Activate(TRUE);

	for (int i = 0; i < GCM_CONTROL_COUNT_EDIT; ++i){
		string text = m_pConfigFileLanguage->Get("ToolTips", GCMUtility::IntToString(2000 + i));
		if (text != ""){
			m_ToolTip.AddTool(&m_Edit[i], text.c_str());
		}
	}
	for (int i = 0; i < GCM_CONTROL_COUNT_CHECK_BUTTON; ++i){
		string text = m_pConfigFileLanguage->Get("ToolTips", GCMUtility::IntToString(2100 + i));
		if (text != ""){
			m_ToolTip.AddTool(&m_CheckButton[i], text.c_str());
		}
	}
	for (int i = 0; i < GCM_CONTROL_COUNT_BUTTON_COMMNAD; ++i){
		string text = m_pConfigFileLanguage->Get("ToolTips", GCMUtility::IntToString(2200 + i));
		if (text != ""){
			m_ToolTip.AddTool(&m_btnCommand[i], text.c_str());
		}
	}
	for (int i = 0; i < GCM_CONTROL_COUNT_COMBO_BOX; ++i){
		string text = m_pConfigFileLanguage->Get("ToolTips", GCMUtility::IntToString(2400 + i));
		if (text != ""){
			m_ToolTip.AddTool(&m_ComboBox[i], text.c_str());
		}
	}
}

BOOL CGCM_RenamerDlg::PreTranslateMessage(MSG *pMsg)
{
	if (::IsWindow(m_ToolTip.m_hWnd))
	{
		switch(pMsg->message)
		{
		case WM_LBUTTONDOWN: 
		case WM_MOUSEMOVE:
		case WM_LBUTTONUP: 
		case WM_RBUTTONDOWN:
		case WM_MBUTTONDOWN: 
		case WM_RBUTTONUP:
		case WM_MBUTTONUP:
			m_ToolTip.RelayEvent(pMsg);
			break;
		}
	}
	return CDialog::PreTranslateMessage(pMsg);
}

void CGCM_RenamerDlg::SetStateText(const string& str)
{
	m_StaticState.SetWindowText(str.c_str());
}

void CGCM_RenamerDlg::SetProgressBarPosition(int n)
{
	m_Progress.SetPos(n);
}

void CGCM_RenamerDlg::LoadLanguage(const string& language)
{
	m_pCD->Restore();
	m_pConfigFileLanguage->SetHeader(LanguageFileHeader);
	string file_name = ".\\language\\" + language + ".ini";
	m_pConfigFileLanguage->Load(file_name);
	for (int i = 0; i < GCM_CONTROL_COUNT_BUTTON_COMMNAD; ++i){
		string text = m_pConfigFileLanguage->Get("Button", GCMUtility::IntToString(i));
		if (text != ""){
			m_btnCommand[i].SetWindowText(text.c_str());
		}
	}
	for (int i = 0; i < GCM_CONTROL_COUNT_BUTTON_REF; ++i){
		string text = m_pConfigFileLanguage->Get("Button", "REF");
		if (text != ""){
			m_btnRef[i].SetWindowText(text.c_str());
		}
	}
	for (int i = 0; i < GCM_CONTROL_COUNT_CHECK_BUTTON; ++i){
		string text = m_pConfigFileLanguage->Get("CheckBox", GCMUtility::IntToString(i));
		if (text != ""){
			m_CheckButton[i].SetWindowText(text.c_str());
		}
	}
	for (int i = 0; i < GCM_CONTROL_COUNT_EXPLANATION; ++i){
		string text = m_pConfigFileLanguage->Get("EditBox", GCMUtility::IntToString(i));
		if (text != ""){
			m_StaticExplanation[i].SetWindowText(text.c_str());
		}
	}
	for (int i = 0; i < GCM_CONTROL_COUNT_GROUP; ++i){
		string text = m_pConfigFileLanguage->Get("GroupBox", GCMUtility::IntToString(i));
		if (text != ""){
			m_StaticGroup[i].SetWindowText(text.c_str());
		}
	}
	{
		string text = m_pConfigFileLanguage->Get("State", "WAIT");
		m_StaticState.SetWindowText(text.c_str());
	}
}

void CGCM_RenamerDlg::ReloadLanguageList()
{
	m_pCD->Restore();
	m_ComboBox[1].ResetContent();
	CFileFind finder;
	BOOL working = finder.FindFile(".\\language\\*.*");
	while (working){
		working = finder.FindNextFile();
		if (finder.IsDots())
			continue;
		if (finder.IsDirectory())
			continue;
		m_ComboBox[1].InsertString(-1, finder.GetFileTitle());
	}
    finder.Close();
	if (m_ComboBox[1].SelectString(-1, m_strCurrentLanguage.c_str()) == LB_ERR){
		if (m_ComboBox[1].SetCurSel(0) == LB_ERR){
			return;
		}
		CString buffer;
		m_ComboBox[1].GetLBText(0, buffer);
		m_strCurrentLanguage = (LPCTSTR)buffer;
	}
	LoadLanguage(m_strCurrentLanguage);
}

void CGCM_RenamerDlg::OnCbnSelchangeLanguage()
{
	CString buf;
	m_ComboBox[1].GetLBText(m_ComboBox[1].GetCurSel(), buf);
	m_strCurrentLanguage = (LPCTSTR)buf;
	LoadLanguage(m_strCurrentLanguage);
}

void CGCM_RenamerDlg::EnumerateDaemonDrive()
{
	m_ComboBox[2].ResetContent();
	for (char letter = 'A'; letter <= 'Z'; letter++){
		string drive(1, letter);
		drive += ":";
		if (GetDriveType(drive.c_str()) == DRIVE_CDROM){
			m_ComboBox[2].AddString(drive.c_str());
		}
	}
}

void CGCM_RenamerDlg::SelectDaemonDrive(const string& drive)
{
	EnumerateDaemonDrive();
	if (m_ComboBox[2].SelectString(0, drive.c_str()) == CB_ERR){
		m_ComboBox[2].SetCurSel(0);
	}
}

const std::string CGCM_RenamerDlg::GetSelectedDaemonDrive()const
{
	CString temp;
	m_ComboBox[2].GetLBText(m_ComboBox[2].GetCurSel(), temp);
	return string((LPCTSTR)temp);
}
