#ifndef FILE_NAME_FORM_H
#define FILE_NAME_FORM_H

#include <string>
#include "Database.h"
#include "LetterWidth.h"

class GCMFileNameForm
{
private:
	std::string m_strForm;
	GCMLetterWidth m_LetterWidth;
	std::string m_strExtention;

	void FormReplace(std::string& str, const std::string& from, const std::string& to) const;
	const std::string InsertDateDelim(const std::string& in, const std::string& delim)const;
	const std::string InsertExtention(const std::string& struct_file)const;
public:
	GCMFileNameForm(const std::string& form, const GCMConfigStructLetterWidth& config);
	const std::string GetFormedFileName(const GCMDatabase::DATA& data, const std::string& file_title);
};

#endif
