#include "Header.h"
#include "Utility.h"
#include "FileNameForm.h"

using namespace std;

GCMFileNameForm::GCMFileNameForm(const string& form, const GCMConfigStructLetterWidth& config)
:m_strForm(form), m_LetterWidth(config)
{
}

const string GCMFileNameForm::InsertExtention(const string& find_file)const
{
	vector<string> vec_find;
	vec_find.push_back("*");
	FIND_RESULT find = GCMUtility::FindFile(find_file, vec_find);
	vector<string> vec_extention;
	vec_extention.swap(find.second);
	for (vector<string>::iterator i = vec_extention.begin(); i != vec_extention.end(); ++i){
		i->erase(0, i->find_last_of('.') + 1);
	}
	string res;
	for (vector<string>::iterator i = vec_extention.begin(); i != vec_extention.end(); ++i){
		if (i != vec_extention.begin()){
			res += "+";
		}
		res += *i;
	}
	return res;
}

const string GCMFileNameForm::GetFormedFileName(const GCMDatabase::DATA& data, const string& file_title)
{
	string extention;
	if (!file_title.empty()){
		extention = InsertExtention(file_title);
	}
	string res(m_strForm);
	FormReplace(res, "%i", data.id);
	//ȎSppϊ
	string name(m_LetterWidth.ChangeString(data.name));
	FormReplace(res, "%n", name);
	FormReplace(res, "%l", data.language);
	FormReplace(res, "%s", data.selling);
	FormReplace(res, "%p", data.price);
	FormReplace(res, "%g", data.genre);
	FormReplace(res, "%D", data.date);
	FormReplace(res, "%d", data.date);
	FormReplace(res, "%m", data.machine);
	FormReplace(res, "%r", data.remark);
	FormReplace(res, "%e", extention);
	return res;
}

void GCMFileNameForm::FormReplace(string& str, const string& from, const string& to) const
{
	size_t index;
	while ((index = str.find(from)) != string::npos){
		//%D̂ݕʏ
		if (from == "%D" && index < str.size() - 2){
			str.replace(index, 3, InsertDateDelim(to, str.substr(index + 2, 1)));
			continue;
		}
		str.replace(index, 2, to);
	}
}

const string GCMFileNameForm::InsertDateDelim(const string& in, const string& delim)const
{
	if (delim == "/" || delim.size() > 1){
		return in;
	}
	string res;
	if (in.size() == 6){
		res = in.substr(0, 2) + delim + in.substr(2, 2) + delim + in.substr(4, 2);
	} else if (in.size() == 8){
		res = in.substr(0, 4) + delim + in.substr(4, 2) + delim + in.substr(6, 2);
	} else {
		res = in;
	}
	return res;
}
