#ifndef FILE_H
#define FILE_H

#include <vector>
#include <string>

class GCMArchiverBase;

//RXgN^ɓn\
struct GCMConfigStructRename{
	std::string m_strFileTitle, m_strDaemon, m_strDrive;
	bool m_bArchiver, m_bFileCrc;
	HWND m_hWnd;
};

//l[֐ɓn\
struct GCMConfigStructFile{
	std::string m_strRenamed;
	bool m_bChangeTimestamp;
	CTime m_TimeStamp;
};

class GCMFileBase
{
private:
	const std::string GetCRCFile(const std::string& file_name)const;
	const std::string GetCRCBuffer(const char* ptr, unsigned int size)const;
	PROCESS_INFORMATION m_ProcessInformation;
protected:
	std::string m_strFileTitle;
	std::string m_strTargetFileName;
	std::string m_strTempExtractFolder;
	std::vector<std::string> m_vecFileExtention;
	std::vector<std::string> m_vecID;
	bool m_bOpenSucceeded, m_bArchiver, m_bInitSucceeded;

	std::auto_ptr<GCMArchiverBase> m_pArchiver;
	const std::string EmptyString;

	bool FindTargetFile();

	bool LaunchDaemonTools(bool mount, const std::string& daemon, bool wait);
	void WaitForDaemonTools() const;
	void RenameCueFile(const std::string& renamed) const;
	void RenameMdsFile(const std::string& renamed) const;
	bool AddCRCFile(const std::string& file_name);
	bool AddCRCBuffer(const char* ptr, unsigned int size);

	void InsertExtention(GCMConfigStructFile& struct_file)const;

	static const int FileBufferSize;
	static const std::string TempFileTitle;
public:
	GCMFileBase(const GCMConfigStructRename& config, const std::string& extention);
	virtual ~GCMFileBase();
	bool IsOpend() const {return m_bOpenSucceeded;}

	virtual const std::string& GetID(int n) const;
	virtual int GetNumberOfID() const;
	virtual bool Rename(const GCMConfigStructFile& renamed);
	const std::string& GetFileTitle()const {return m_strFileTitle;}
	const std::string GetFindFileTarget()const;
};

class GCMFileGCM : public GCMFileBase
{
private:
	static const std::string FileExtention;
public:
	GCMFileGCM(const GCMConfigStructRename& config);
};

class GCMFileGBA : public GCMFileBase
{
private:
	static const std::string FileExtention;
public:
	GCMFileGBA(const GCMConfigStructRename& config);
};

class GCMFilePS : public GCMFileBase
{
private:
	static const std::string FileExtention;
public:
	GCMFilePS(const GCMConfigStructRename& config);
	virtual bool Rename(const GCMConfigStructFile& renamed);
};

class GCMFilePS2 : public GCMFileBase
{
private:
	static const std::string FileExtention;
public:
	GCMFilePS2(const GCMConfigStructRename& config);
	virtual bool Rename(const GCMConfigStructFile& renamed);
};

class GCMFileDC : public GCMFileBase
{
private:
	static const std::string FileExtention;
	static const std::string TargetString;
public:
	GCMFileDC(const GCMConfigStructRename& config);
	const std::string FindProductNumber() const;
};

class GCMFileN64 : public GCMFileBase
{
private:
	static const std::string FileExtention;
public:
	GCMFileN64(const GCMConfigStructRename& config);
};

class GCMFileSNES : public GCMFileBase
{
private:
	static const std::string FileExtention;
	static const int SkipSize;
public:
	GCMFileSNES(const GCMConfigStructRename& config);
};

class GCMFileNES : public GCMFileBase
{
private:
	static const std::string FileExtention;
	static const int SkipSize;
public:
	GCMFileNES(const GCMConfigStructRename& config);
};

class GCMFileFDS : public GCMFileBase
{
private:
	static const std::string FileExtention;
public:
	GCMFileFDS(const GCMConfigStructRename& config);
};

class GCMFileSS : public GCMFileBase
{
private:
	static const std::string FileExtention;
public:
	GCMFileSS(const GCMConfigStructRename& config);
	virtual bool Rename(const GCMConfigStructFile& renamed);
};

class GCMFileMEGACD : public GCMFileBase
{
private:
	static const std::string FileExtention;
	static const std::string TargetString;
	static const int BufferSize;
	static const int ReadSize;
public:
	GCMFileMEGACD(const GCMConfigStructRename& config);
	virtual bool Rename(const GCMConfigStructFile& renamed);
};

class GCMFileNEOGEOCD : public GCMFileBase
{
private:
	static const std::string FileExtention;
	static const int BufferSize;
public:
	GCMFileNEOGEOCD(const GCMConfigStructRename& config);
	virtual bool Rename(const GCMConfigStructFile& renamed);
};

class GCMFileNEOGEO : public GCMFileBase
{
private:
	static const std::string FileExtention;
public:
	GCMFileNEOGEO(const GCMConfigStructRename& config);
	virtual bool Rename(const GCMConfigStructFile& renamed);
};

class GCMFilePCECD : public GCMFileBase
{
private:
	static const std::string FileExtention;
	static const int BufferSize;
	static const int BlockSize;
	static const int SectorCount;
public:
	GCMFilePCECD(const GCMConfigStructRename& config);
	virtual bool Rename(const GCMConfigStructFile& renamed);
};

class GCMFileWS : public GCMFileBase
{
private:
	static const std::string FileExtention;
public:
	GCMFileWS(const GCMConfigStructRename& config);
};

#endif
