#include "Header.h"
#include "stdafx.h"
#include <algorithm>
#include <fstream>
#include <sstream>
#include <boost/crc.hpp>
#include "CDImage.h"
#include "CDFileSystem.h"
#include "Utility.h"
#include "Archiver.h"
#include "File.h"

using namespace std;

const int GCMFileBase::FileBufferSize(1048576);
const string GCMFileBase::TempFileTitle("GCM_RenamerTemporally");
GCMFileBase::GCMFileBase(const GCMConfigStructRename& config, const string& extention)
{
	m_strFileTitle = config.m_strFileTitle;
	m_bArchiver = false;
	m_bOpenSucceeded = false;
	m_bInitSucceeded = false;
	if (config.m_bArchiver){
		vector<string> vec_archiver_extention;
		vec_archiver_extention.push_back("zip");
		vec_archiver_extention.push_back("rar");
		vec_archiver_extention.push_back("7z");
		vec_archiver_extention.push_back("lzh");
		vec_archiver_extention.push_back("gca");
		vec_archiver_extention.push_back("cab");
		FIND_RESULT find_result = GCMUtility::FindFile(m_strFileTitle, vec_archiver_extention);
		if (find_result.first){
			//ꎞfBNg쐬
			auto_ptr<TCHAR> temp_buffer = auto_ptr<TCHAR>(new TCHAR[MAX_PATH + 1]);
			GetTempPath(MAX_PATH + 1, temp_buffer.get());
			m_strTempExtractFolder = string(temp_buffer.get()) + "GCM_Renamer";
			string target_archive(*(find_result.second.begin()));
			string extention = GCMUtility::ToLower(target_archive.substr(target_archive.find_last_of('.')));
			target_archive.erase(target_archive.find_last_of('.'));
			target_archive.insert(target_archive.end(), extention.begin(), extention.end());
			GCMArchiverConfigStruct archiver_config;
			archiver_config.archive = target_archive;
			archiver_config.hwnd = config.m_hWnd;
			archiver_config.temp_folder = m_strTempExtractFolder;
			if (target_archive.find(".zip") != string::npos){
				m_pArchiver = auto_ptr<GCMArchiverBase>(new GCMArchiver7Z(archiver_config));
			} else if (target_archive.find(".rar") != string::npos){
				m_pArchiver = auto_ptr<GCMArchiverBase>(new GCMArchiverRAR(archiver_config));
			} else if (target_archive.find(".7z") != string::npos){
				m_pArchiver = auto_ptr<GCMArchiverBase>(new GCMArchiver7Z(archiver_config));
			} else if (target_archive.find(".lzh") != string::npos){
				m_pArchiver = auto_ptr<GCMArchiverBase>(new GCMArchiverLZH(archiver_config));
			} else if (target_archive.find(".gca") != string::npos){
				m_pArchiver = auto_ptr<GCMArchiverBase>(new GCMArchiverGCA(archiver_config));
			} else if (target_archive.find(".cab") != string::npos){
				m_pArchiver = auto_ptr<GCMArchiverBase>(new GCMArchiver7Z(archiver_config));
	//			m_pArchiver = new GCMArchiverCAB(archiver_config);
			} else{
				return;
			}
			if (m_pArchiver->IsOpened()){
				m_bArchiver = true;
			}
		}
	}
	{
		istringstream iss(extention);
		string work;
		while (iss >> work){
			m_vecFileExtention.push_back(work);
		}
	}
	if (FindTargetFile()){
		m_bInitSucceeded = true;
	} else {
		return;
	}
	if (config.m_bFileCrc){
		AddCRCFile(m_strTargetFileName);
	}
}

GCMFileBase::~GCMFileBase()
{
}

bool GCMFileBase::FindTargetFile()
{
	FIND_RESULT res = GCMUtility::FindFile(GetFindFileTarget(), m_vecFileExtention);;
	if (res.first){
		m_strTargetFileName = *(res.second.begin());
		return true;
	}
	return false;
}

bool GCMFileBase::Rename(const GCMConfigStructFile& struct_file)
{
	GCMConfigStructFile renamed(struct_file);
	CFileFind finder;
	BOOL working = finder.FindFile((m_strFileTitle + ".*").c_str());
	vector<string> vec_file;
	string root = GCMUtility::GetRootFolderName(m_strFileTitle);

	while (working){
		working = finder.FindNextFile();
		
		if (finder.IsDots() || finder.IsDirectory())
			continue;

		vec_file.push_back((LPCTSTR)finder.GetFileName());
		if (renamed.m_bChangeTimestamp){
			CFileStatus status;
			CFile::GetStatus((LPCTSTR)finder.GetFilePath(), status);
			status.m_ctime = renamed.m_TimeStamp;
			status.m_mtime = renamed.m_TimeStamp;
			status.m_atime = renamed.m_TimeStamp;
			CFile::SetStatus((LPCTSTR)finder.GetFilePath(), status);
		}
	}
	finder.Close();

	bool success = false;
	vector<string>::iterator i = vec_file.begin();
	while (i != vec_file.end()){
		string from = root + "\\" + *i;
		string to = root + "\\" + renamed.m_strRenamed + i->substr(i->find_last_of('.'));
		if (MoveFile(from.c_str(), to.c_str())){
			success = true;
		}
		++i;
	}
	m_strFileTitle = root + "\\" + renamed.m_strRenamed;
	return success;
}

const string& GCMFileBase::GetID(int n) const
{
	if (n >= (int)m_vecID.size()){
		return EmptyString;
	}
	return m_vecID[n];
}

int GCMFileBase::GetNumberOfID() const
{
	return (int)m_vecID.size();
}

bool GCMFileBase::LaunchDaemonTools(bool mount, const string& daemon, bool wait)
{
	//Daemon̋N
	STARTUPINFO si;
	//PROCESS_INFORMATION pi;

	memset(&si, 0, sizeof(STARTUPINFO));
	si.cb = sizeof(STARTUPINFO);

	string command;
	if (mount){
		command = "\"" + daemon + "\" -mount 0,\"" + m_strTargetFileName + "\"";
	} else {
		command = "\"" + daemon + "\" -unmount 0";
	}

	//	si.dwFlags = STARTF_USESHOWWINDOW;
	//	si.wShowWindow = SW_HIDE;

	if (!CreateProcess(NULL, (LPSTR)command.c_str(), NULL, NULL, FALSE, 0, NULL, NULL, &si, &m_ProcessInformation)){
		return false;
	}

	if (wait){
		WaitForSingleObject(m_ProcessInformation.hProcess, INFINITE);
		CloseHandle(m_ProcessInformation.hProcess);
	}
	return true;
}

void GCMFileBase::WaitForDaemonTools() const
{
	WaitForSingleObject(m_ProcessInformation.hProcess, INFINITE);
	CloseHandle(m_ProcessInformation.hProcess);
}

const string GCMFileBase::GetCRCFile(const string& file_name)const
{
	CFile file;
	if (!file.Open(file_name.c_str(), CFile::modeRead | CFile::shareDenyWrite | CFile::osSequentialScan)){
		return "FFFFFFFF";
	}
	unsigned int file_size = (unsigned int)file.GetLength();
	auto_ptr<char> buffer = auto_ptr<char>(new char[file_size]);
	file.Read(buffer.get(), (unsigned int)file_size);
	return GetCRCBuffer(buffer.get(), file_size);
}

bool GCMFileBase::AddCRCFile(const string& file_name)
{
	string crc(GetCRCFile(file_name));
	if (crc != "FFFFFFFF"){
        m_vecID.push_back(crc);
		return true;
	}
	return false;
}

const std::string GCMFileBase::GetCRCBuffer(const char* ptr, unsigned int size)const
{
	boost::crc_32_type boost_crc;
	boost_crc.process_bytes(ptr, size);
	unsigned int crc = boost_crc.checksum();
	ostringstream oss;
	oss << std::hex << crc;
	string res = GCMUtility::ToUpper(oss.str());
	if (res.size() < 8){
		res = string(8 - res.size(), '0') + res;
	}
	return res;
}

bool GCMFileBase::AddCRCBuffer(const char* ptr, unsigned int size)
{
	string crc(GetCRCBuffer(ptr, size));
	if (crc != "FFFFFFFF"){
        m_vecID.push_back(crc);
		return true;
	}
	return false;
}

void GCMFileBase::RenameCueFile(const string& renamed) const
{
	vector<string> vec_extention;
	vec_extention.push_back("cue");

	FIND_RESULT find = GCMUtility::FindFile(m_strFileTitle, vec_extention);
	if (!find.first){
		return;
	}
	string from = *find.second.begin();
	string to = GCMUtility::GetRootFolderName(m_strFileTitle) + "\\" + TempFileTitle + ".cue";
	if (from != to){
		ifstream ifs;
		ifs.open(from.c_str());
		string first_line;
		getline(ifs, first_line);

		size_t i1 = first_line.find('\"'), i2 = first_line.find_last_of('.');
		string pre(first_line.substr(0, i1 + 1));
		string after(first_line.substr(i2));

		ofstream ofs;
		ofs.open(to.c_str());
		ofs << pre << renamed << after << endl;

		string others;
		while (getline(ifs, others)){
			ofs << others << endl;
		}
		ofs.close();
		ifs.close();

		DeleteFile(from.c_str());
		MoveFile(to.c_str(), from.c_str());
	}
}

void GCMFileBase::RenameMdsFile(const string& renamed) const
{
	vector<string> vec_extention;
	vec_extention.push_back("mds");

	FIND_RESULT find = GCMUtility::FindFile(m_strFileTitle, vec_extention);
	if (!find.first){
		return;
	}
	string from = *find.second.begin();
	string to = GCMUtility::GetRootFolderName(m_strFileTitle) + "\\" + TempFileTitle + ".mds";
	if (from != to){
		CFile file_from;
		if (!file_from.Open(from.c_str(), CFile::modeRead | CFile::shareDenyWrite | CFile::osSequentialScan)){
			return;
		}
		unsigned int file_size = (unsigned int)file_from.GetLength();
		auto_ptr<char> buffer = auto_ptr<char>(new char[file_size]);
		file_from.Read(buffer.get(), file_size);
		file_from.Close();
		unsigned long divide = 0, ptr_index = 0;
		CopyMemory(&divide, buffer.get() + 0xA0, sizeof(unsigned long));
		CopyMemory(&ptr_index, buffer.get() + 0xA4, sizeof(unsigned long));

		CFile file_to;
		if (!file_to.Open(to.c_str(), CFile::modeCreate | CFile::modeWrite | CFile::shareExclusive)){
			return;
		}
		file_to.Write(buffer.get(), ptr_index);

		vector<string> vec_name;
		vec_name.reserve(divide);
		vector<unsigned long long> vec_sector;
		vec_sector.reserve(divide);
		for (int i = 0; i < (int)divide; ++i){
			unsigned long long ptr_name = 0, sector = 0;
			CopyMemory(&ptr_name, buffer.get() + ptr_index + i * 16, sizeof(unsigned long long));
			CopyMemory(&sector, buffer.get() + ptr_index + i * 16 + 8, sizeof(unsigned long long));
			vec_sector.push_back(sector);
			string name = (char*)buffer.get() + ptr_name;
			string extention = name.substr(name.find_last_of("."));
			vec_name.push_back(renamed + extention);
		}
		unsigned long long ptr = ptr_index + divide * 16;
		for (int i = 0; i < (int)divide; ++i){
			file_to.Write(&ptr, sizeof(unsigned long long));
			file_to.Write(&vec_sector[i], sizeof(unsigned long long));
			ptr += vec_name[i].size() + 1;
		}
		for (int i = 0; i < (int)divide; ++i){
			file_to.Write(vec_name[i].c_str(), (UINT)vec_name[i].size() + 1);
		}
		file_to.Close();

		DeleteFile(from.c_str());
		MoveFile(to.c_str(), from.c_str());
	}
}

const string GCMFileBase::GetFindFileTarget()const
{
	if (m_bArchiver){
		return m_strTempExtractFolder + "\\*";
	} else {
		return m_strFileTitle;
	}
}

//CVQ[L[u
const string GCMFileGCM::FileExtention("gcm iso");
GCMFileGCM::GCMFileGCM(const GCMConfigStructRename& config) : GCMFileBase(config, FileExtention)
{
	if (!m_bInitSucceeded){
		return;
	}

	CFile file;
	if (!file.Open(m_strTargetFileName.c_str(), CFile::modeRead | CFile::shareDenyWrite | CFile::osRandomAccess)){
		return;
	}
	if (file.GetLength() < 1024){
		return;
	}

	m_bOpenSucceeded = true;

	auto_ptr<char> id_buffer = auto_ptr<char>(new char[16 + 1]);
	auto_ptr<char> title_buffer = auto_ptr<char>(new char[256 + 1]);
	ZeroMemory(id_buffer.get(), 16 + 1);
	ZeroMemory(title_buffer.get(), 256 + 1);
	file.Read((void*)id_buffer.get(), 16);
	file.Seek(32, CFile::begin);
	file.Read((void*)title_buffer.get(), 256);
	file.Close();

	string id6 = id_buffer.get();
	m_vecID.push_back(id6.substr(0, 4));
	m_vecID.push_back(id6);
	m_vecID.push_back(title_buffer.get());
}

//GBA
const string GCMFileGBA::FileExtention("gba");
GCMFileGBA::GCMFileGBA(const GCMConfigStructRename& config) : GCMFileBase(config, FileExtention)
{
	if (!m_bInitSucceeded){
		return;
	}

	CFile file;
	if (!file.Open(m_strTargetFileName.c_str(), CFile::modeRead | CFile::shareDenyWrite | CFile::osRandomAccess | CFile::osRandomAccess)){
		return;
	}
	if (file.GetLength() < 1024){
		return;
	}

	m_bOpenSucceeded = true;

	auto_ptr<char> buffer = auto_ptr<char>(new char[24]);
	ZeroMemory((void*)buffer.get(), 24);

	file.Seek(160, CFile::begin);
	file.Read((void*)buffer.get(), 18);
	file.Close();

	string title(buffer.get());
	if (title.size() > 12){
		title = title.substr(0, 12);
	}

	string id6(buffer.get() + 12);
	m_vecID.push_back(id6.substr(0, 4));
	m_vecID.push_back(id6);
	m_vecID.push_back(title);
}

//vXe
const string GCMFilePS::FileExtention("img bin iso cue cdi ccd");
GCMFilePS::GCMFilePS(const GCMConfigStructRename& config) : GCMFileBase(config, FileExtention)
{
	if (!m_bInitSucceeded){
		return;
	}

	string system_cnf = "SYSTEM.CNF";
	GCMCDFileSystem file_system(m_strTargetFileName);
	if (!file_system.IsOpen()){
		return;
	}

	int number_system_cnf = file_system.FileOpen(system_cnf);
	if (number_system_cnf < 0){
		//PSX.EXE
		string crc = file_system.GetFileCRC("PSX.EXE");
		if (crc != "FFFFFFFF"){
			m_vecID.push_back(crc);
			m_bOpenSucceeded = true;
		}
		return;
	}
	const char *ptr_system_cnf = file_system.GetFilePointer(number_system_cnf);
	unsigned int file_size_system_cnf = file_system.GetFileSize(number_system_cnf);
	string target_string = "BOOT";
	const char *ptr_boot = search(ptr_system_cnf, ptr_system_cnf + file_size_system_cnf, target_string.c_str(), target_string.c_str() + target_string.size());
	if (ptr_boot == ptr_system_cnf + file_size_system_cnf){
		return;
	}
	char buffer_line[256 + 1];
	ZeroMemory(buffer_line, 256 + 1);
	memcpy(buffer_line, ptr_boot, 256);
	string line = buffer_line;
	line.erase(line.find('\n'));
	string temp_id = line.substr(line.find(':'));
	size_t index = temp_id.find(';');
	if (index != string::npos){
		temp_id.erase(index);
	}
	if (temp_id.find('.') - temp_id.find('_') == 4){
		//^
		string id(temp_id.substr(temp_id.find('_') - 4));
		id.erase(id.find('_'), 1);
		id.erase(id.find('.'), 1);
		m_vecID.push_back(GCMUtility::ToUpper(id));
	} else {
		//^ԂȂ
		//EXEt@CCRCZoIDƂ
		string exe_file = temp_id.substr(2);
		string crc = file_system.GetFileCRC(exe_file);
		if (crc != "FFFFFFFF"){
			m_vecID.push_back(crc);
			m_bOpenSucceeded = true;
		}
		return;
	}

	m_bOpenSucceeded = true;
}

bool GCMFilePS::Rename(const GCMConfigStructFile& renamed)
{
	RenameCueFile(renamed.m_strRenamed);
	RenameMdsFile(renamed.m_strRenamed);
	return GCMFileBase::Rename(renamed);
}

//vXe2
const string GCMFilePS2::FileExtention("img bin iso cue bwt cdi b5t ccd mds nrg pdi");
GCMFilePS2::GCMFilePS2(const GCMConfigStructRename& config) : GCMFileBase(config, FileExtention)
{
	if (!m_bInitSucceeded){
		return;
	}

	if (!LaunchDaemonTools(true, config.m_strDaemon, true)){
		return;
	}

	string system_cnf = config.m_strDrive.substr(0, 1) + ":\\SYSTEM.CNF";
	ifstream ifs;
	ifs.open(system_cnf.c_str());

	if (!ifs.is_open()){
		ifs.close();
		//PSX.EXECRCZoIDƂBCRČvZ͊ODLL
		string exe_file = config.m_strDrive.substr(0, 1) + ":\\PSX.EXE";
		if (!AddCRCFile(exe_file)){
			LaunchDaemonTools(false, config.m_strDaemon, true);
			return;
		}
	} else {
		string line;
		while (getline(ifs, line)){
			if (line.find("BOOT") != string::npos){
				break;
			}
		}
		ifs.close();
		string temp = line.substr(line.find(':'));
		size_t index = temp.find(';');
		if (index != string::npos){
			temp.erase(index);
		}

		if (temp.find('.') - temp.find('_') == 4){
			//^
			string id(temp.substr(temp.find('_') - 4));
			id.erase(id.find('_'), 1);
			id.erase(id.find('.'), 1);
			m_vecID.push_back(GCMUtility::ToUpper(id));
		} else {
			//^ԂȂ
			/*EXEt@CCRCZoIDƂBCRČvZ͊ODLL*/
			string exe_file = config.m_strDrive.substr(0, 1) + temp;
			if (!AddCRCFile(exe_file)){
				LaunchDaemonTools(false, config.m_strDaemon, true);
				return;
			}
		}
	}

	if (!LaunchDaemonTools(false, config.m_strDaemon, true)){
		return;
	}
	
	m_bOpenSucceeded = true;
}

bool GCMFilePS2::Rename(const GCMConfigStructFile& renamed)
{
	RenameCueFile(renamed.m_strRenamed);
	RenameMdsFile(renamed.m_strRenamed);
	return GCMFileBase::Rename(renamed);
}

//h[LXg
const string GCMFileDC::FileExtention("cdi");
GCMFileDC::GCMFileDC(const GCMConfigStructRename& config) : GCMFileBase(config, FileExtention)
{
	if (!m_bInitSucceeded){
		return;
	}

	string id;
	if ((id = FindProductNumber()) != ""){
		m_vecID.push_back(id);
	}

	GCMCDFileSystem file_system(m_strTargetFileName);
	string crc1 = file_system.GetFileCRC("0GDTEX.PVR");
	if (crc1 != "FFFFFFFF"){
		m_vecID.push_back(crc1);
	}
	string crc2 = file_system.GetFileCRC("1ST_READ.BIN");
	if (crc2 != "FFFFFFFF"){
		m_vecID.push_back(crc2);
	}

	if (!m_vecID.empty()){
		m_bOpenSucceeded = true;
	}
}

const string GCMFileDC::TargetString("SEGA");
const string GCMFileDC::FindProductNumber() const
{
	//FCDUtil𗘗pip.bin̋߂܂ŃV[gJbg!!AVer4ɂΉ
	LONGLONG offset;
	GCMCDImage image(m_strTargetFileName);
	if (image.IsOpen()){
		offset = (LONGLONG)image.GetOffset(image.GetNumberOfTrack() - 1);
		CFileStatus status;
		CFile::GetStatus(m_strTargetFileName.c_str(), status);
		if ((LONGLONG)status.m_size < offset){
			offset = 0;
		}
	} else {
		offset = 0;
	}


	string res;
	CFile file;
	if (!file.Open(m_strTargetFileName.c_str(), CFile::modeRead | CFile::shareDenyWrite | CFile::osRandomAccess)){
		return res;
	}
	if (file.GetLength() < 1024){
		return res;
	}
	file.Seek(offset, CFile::begin);
	auto_ptr<char> buffer = auto_ptr<char>(new char[FileBufferSize + 1]);
	ZeroMemory((void*)buffer.get(), FileBufferSize + 1);
	UINT read_size;
	while ((read_size = file.Read((void*)buffer.get(), FileBufferSize)) > 0){
		char *begin = (char*)buffer.get();
		char *end = (char*)(buffer.get() + FileBufferSize);
		char *address;
		if ((address = search(begin, end, TargetString.begin(), TargetString.end())) != end){
            offset += (LONGLONG)(address - begin + 64);
			auto_ptr<char> id_buffer = auto_ptr<char>(new char[9]);
			ZeroMemory((void*)id_buffer.get(), 9);
			file.Seek((LONGLONG)offset, CFile::begin);
			file.Read((void*)id_buffer.get(), 8);
			res = id_buffer.get();
			size_t index;
			if ((index = res.find(' ')) != string::npos){
				res.erase(index);
			}
			if ((index = res.find('-')) != string::npos){
				res.erase(index, 1);
			}
			break;
		}
		offset += (LONGLONG)read_size;
	}
	file.Close();
	return res;
}

//N64
const string GCMFileN64::FileExtention("v64");
GCMFileN64::GCMFileN64(const GCMConfigStructRename& config) : GCMFileBase(config, FileExtention)
{
	if (!m_bInitSucceeded){
		return;
	}

	CFile file;
	if (!file.Open(m_strTargetFileName.c_str(), CFile::modeRead | CFile::shareDenyWrite | CFile::osRandomAccess)){
		return;
	}
	if (file.GetLength() < 1024){
		return;
	}

	auto_ptr<char> buffer_id = auto_ptr<char>(new char[7]);
	ZeroMemory((void*)buffer_id.get(), 7);
	file.Seek(58, CFile::begin);
	file.Read((void*)buffer_id.get(), 6);
	file.Close();

	string temp = buffer_id.get();
	string id_normal = temp.substr(1, 4);
	string id_interleave = temp.substr(0, 1) + temp.substr(3, 1) + temp.substr(2, 1) + temp.substr(5, 1);
	if (isalnum(id_normal[0])){
		m_vecID.push_back(id_normal);
	} else {
		m_vecID.push_back(id_interleave);
	}

	m_bOpenSucceeded = true;
}

//X[p[t@~R
const string GCMFileSNES::FileExtention("smc");
const int GCMFileSNES::SkipSize = 512;
GCMFileSNES::GCMFileSNES(const GCMConfigStructRename& config) : GCMFileBase(config, FileExtention)
{
	if (!m_bInitSucceeded){
		return;
	}
	CFile file;
	if (!file.Open(m_strTargetFileName.c_str(), CFile::modeRead | CFile::shareDenyWrite | CFile::osSequentialScan)){
		return;
	}
	int file_size = (int)file.GetLength();
	auto_ptr<char> buffer = auto_ptr<char>(new char[file_size]);
	file.Read(buffer.get(), file_size);
	if (AddCRCBuffer(buffer.get() + SkipSize, file_size - SkipSize)){
		m_bOpenSucceeded = true;
	}
}

//t@~R
const string GCMFileNES::FileExtention("nes");
const int GCMFileNES::SkipSize = 16;
GCMFileNES::GCMFileNES(const GCMConfigStructRename& config) : GCMFileBase(config, FileExtention)
{
	if (!m_bInitSucceeded){
		return;
	}
	CFile file;
	if (!file.Open(m_strTargetFileName.c_str(), CFile::modeRead | CFile::shareDenyWrite | CFile::osSequentialScan)){
		return;
	}
	int file_size = (int)file.GetLength();
	auto_ptr<char> buffer = auto_ptr<char>(new char[file_size]);
	file.Read(buffer.get(), file_size);
	if (AddCRCBuffer(buffer.get() + SkipSize, file_size - SkipSize)){
		m_bOpenSucceeded = true;
	}
}

//t@~RfBXNVXe
const string GCMFileFDS::FileExtention("fds");
GCMFileFDS::GCMFileFDS(const GCMConfigStructRename& config) : GCMFileBase(config, FileExtention)
{
	if (!m_bInitSucceeded){
		return;
	}

	CFile file;
	if (!file.Open(m_strTargetFileName.c_str(), CFile::modeRead | CFile::shareDenyWrite | CFile::osRandomAccess)){
		return;
	}
	if (file.GetLength() < 1024){
		return;
	}

	m_bOpenSucceeded = true;

	auto_ptr<char> buffer = auto_ptr<char>(new char[4]);
	ZeroMemory((void*)buffer.get(), 4);

	file.Seek(32, CFile::begin);
	file.Read((void*)buffer.get(), 3);
	file.Close();

	string id(buffer.get());
	m_vecID.push_back(id);
}

//ZKT^[
const string GCMFileSS::FileExtention("bin");
GCMFileSS::GCMFileSS(const GCMConfigStructRename& config) : GCMFileBase(config, FileExtention)
{
	if (!m_bInitSucceeded){
		return;
	}

	CFile file;
	if (!file.Open(m_strTargetFileName.c_str(), CFile::modeRead | CFile::shareDenyWrite | CFile::osRandomAccess)){
		return;
	}
	if (file.GetLength() < 1024){
		return;
	}

	m_bOpenSucceeded = true;

	auto_ptr<char> buffer = auto_ptr<char>(new char[17]);
	ZeroMemory((void*)buffer.get(), 17);
	LONGLONG offset = 48;
	file.Read((void*)buffer.get(), 4);
	if (string(buffer.get()) == "SEGA"){
		offset = 32;
	}

	file.Seek(offset, CFile::begin);
	file.Read((void*)buffer.get(), 16);
	file.Close();

	string id(buffer.get());
	size_t index;
	if ((index = id.find(' ')) != string::npos){
		id.erase(index);
	}
	m_vecID.push_back(id);
}

bool GCMFileSS::Rename(const GCMConfigStructFile& renamed)
{
	RenameCueFile(renamed.m_strRenamed);
	RenameMdsFile(renamed.m_strRenamed);
	return GCMFileBase::Rename(renamed);
}

//MEGA CD
const string GCMFileMEGACD::FileExtention("cue ccd cdi iso img bin");
const string GCMFileMEGACD::TargetString("GM");
const int GCMFileMEGACD::BufferSize = 2048;
const int GCMFileMEGACD::ReadSize = 512;
GCMFileMEGACD::GCMFileMEGACD(const GCMConfigStructRename& config) : GCMFileBase(config, FileExtention)
{
	if (!m_bInitSucceeded){
		return;
	}

	GCMCDImage image(m_strTargetFileName);
	if (!image.IsOpen()){
		return;
	}
	auto_ptr<char> buffer = auto_ptr<char>(new char[BufferSize]);
	image.GetDataToMemory(buffer.get(), 0, 0, 1);
	if (!AddCRCBuffer(buffer.get(), ReadSize)){
		return;
	}
	m_bOpenSucceeded = true;

	/*
	CFile file;
	if (!file.Open(m_strTargetFileName.c_str(), CFile::modeRead | CFile::shareDenyWrite)){
		return;
	}
	if (file.GetLength() < 1024){
		return;
	}

	auto_ptr<char> buffer = auto_ptr<char>(new char[FileBufferSize + 1]);
	ZeroMemory((void*)buffer.get(), FileBufferSize + 1);
	if (FileBufferSize !=file.Read((void*)buffer.get(), FileBufferSize)){
		return;
	}
	char *begin = (char*)buffer.get();
	char *end = (char*)(buffer.get() + FileBufferSize);
	char *address;
	if ((address = search(begin, end, TargetString.begin(), TargetString.end())) == end){
		return;
	}
    LONGLONG offset = (LONGLONG)(address - begin + 2);
	auto_ptr<char> id_buffer = auto_ptr<char>(new char[10]);
	ZeroMemory((void*)id_buffer.get(), 10);
	file.Seek((LONGLONG)offset, CFile::begin);
	file.Read((void*)id_buffer.get(), 9);
	string id = id_buffer.get();
	while (id.find(' ') != string::npos){
		id.erase(id.find(' '), 1);
	}
	m_vecID.push_back(id);
	m_bOpenSucceeded = true;
	*/
}

bool GCMFileMEGACD::Rename(const GCMConfigStructFile& renamed)
{
	RenameCueFile(renamed.m_strRenamed);
	RenameMdsFile(renamed.m_strRenamed);
	return GCMFileBase::Rename(renamed);
}

//NEOGEO CD
const string GCMFileNEOGEOCD::FileExtention("img iso cue cdi ccd");
const int GCMFileNEOGEOCD::BufferSize = 36;
GCMFileNEOGEOCD::GCMFileNEOGEOCD(const GCMConfigStructRename& config) : GCMFileBase(config, FileExtention)
{
	if (!m_bInitSucceeded){
		return;
	}

	GCMCDImage image(m_strTargetFileName);
	if (!image.IsOpen()){
		return;
	}

	string res;
	CFile file;
	if (!file.Open(m_strTargetFileName.c_str(), CFile::modeRead | CFile::shareDenyWrite | CFile::osRandomAccess)){
		return;
	}
	auto_ptr<char> buffer = auto_ptr<char>(new char[BufferSize + 1]);
	ZeroMemory((void*)buffer.get(), BufferSize + 1);
	LONGLONG offset = image.GetBlockSize(0) * 16 + image.GetSectorOffset(0) + 28;
	file.Seek(offset, CFile::begin);
	file.Read(buffer.get(), BufferSize);
	file.Close();
	string id = buffer.get();
	id.erase(remove(id.begin(), id.end(), ' '), id.end());
	m_vecID.push_back(id);
	m_bOpenSucceeded = true;
	return;
}

bool GCMFileNEOGEOCD::Rename(const GCMConfigStructFile& renamed)
{
	RenameCueFile(renamed.m_strRenamed);
	RenameMdsFile(renamed.m_strRenamed);
	return GCMFileBase::Rename(renamed);
}

//NEOGEO
const string GCMFileNEOGEO::FileExtention("*");
GCMFileNEOGEO::GCMFileNEOGEO(const GCMConfigStructRename& config) : GCMFileBase(config, FileExtention)
{
	if (!m_bInitSucceeded){
		return;
	}

	if (m_bArchiver){
		FIND_RESULT res = GCMUtility::FindFile(m_strTempExtractFolder + "\\*m1", m_vecFileExtention);
		if (res.first){
			m_strTargetFileName = *(res.second.begin());
		}
	} else {
		if (!FindTargetFile()){
			return;
		}
		if (m_strTargetFileName.find("m1.") == string::npos && m_strTargetFileName.find("M1.") == string::npos){
			return;
		}
	}

	if (!AddCRCFile(m_strTargetFileName)){
		return;
	}
	m_bOpenSucceeded = true;
}

bool GCMFileNEOGEO::Rename(const GCMConfigStructFile& renamed)
{
	if (m_bArchiver){
		return GCMFileBase::Rename(renamed);
	}
	return true;
}

//PCECD
const string GCMFilePCECD::FileExtention("cue ccd cdi iso img bin");
const int GCMFilePCECD::BufferSize = 128 * 2048;
const int GCMFilePCECD::BlockSize = 2048;
const int GCMFilePCECD::SectorCount = 128;
GCMFilePCECD::GCMFilePCECD(const GCMConfigStructRename& config) : GCMFileBase(config, FileExtention)
{
	if (!m_bInitSucceeded){
		return;
	}

	GCMCDImage image(m_strTargetFileName);
	if (!image.IsOpen()){
		return;
	}

	int track = image.GetNumberOfTrack();
	if (track > 0){
		track = 1;
	}

	CFile file;
	if (!file.Open(image.GetTrackFilePath(track).c_str(), CFile::modeRead | CFile::shareDenyWrite | CFile::osRandomAccess)){
		return;
	}
	if (file.GetLength() < 1024){
		return;
	}

	LONGLONG offset = image.GetOffset(track);
	int block_size = image.GetBlockSize(track);

	auto_ptr<char> buffer = auto_ptr<char>(new char[BufferSize]);
	ZeroMemory((void*)buffer.get(), BufferSize);
	int header_offset = (m_strTargetFileName.find("cdi") != string::npos) ? image.GetSectorOffset(track) : 16;
	for (int i = 0; i < SectorCount; i++){
		file.Seek(offset + i * block_size + header_offset, CFile::begin);
		file.Read(buffer.get() + i * BlockSize, BlockSize);
	}
	file.Close();

	if (!AddCRCBuffer(buffer.get(), BufferSize)){
		return;
	}
	m_bOpenSucceeded = true;
}

bool GCMFilePCECD::Rename(const GCMConfigStructFile& renamed)
{
	RenameCueFile(renamed.m_strRenamed);
	RenameMdsFile(renamed.m_strRenamed);
	return GCMFileBase::Rename(renamed);
}

//_[X/J[
const string GCMFileWS::FileExtention("ws wsc");
GCMFileWS::GCMFileWS(const GCMConfigStructRename& config) : GCMFileBase(config, FileExtention)
{
	if (!m_bInitSucceeded){
		return;
	}

	if (!config.m_bFileCrc){
		AddCRCFile(m_strTargetFileName);
	}
}
