/*
** ISO/XA treating interfaces
**
** Writen by Sakae Tatibana <tatibana@extra.hu>
**
** 2000, 3/6 coding start
*/

#ifndef ISO_XA_H
#define ISO_XA_H

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "fcd_basic.h"

#ifdef  __cplusplus
extern "C" {
#endif

typedef struct {
	int num;
	char *block[32];
} ISO_HEAD;
	
/*
typedef struct {
	FILE *stream;
	char *path;
	size_t length;

	size_t block_size;
	
	LBN start;
	LBN num_of_block;

	char volume_identifier[32];

	size_t mode; // 1 or 2

	ISO_HEAD memory;
	
} ISO_INFO;
*/
struct ISO_INFO{
	FILE *stream;
	char *path;
	size_t length;

	size_t block_size;
	
	LBN start;
	LBN num_of_block;

	char volume_identifier[32];

	size_t mode; /* 1 or 2 */

	ISO_HEAD memory;
	
};

#ifndef ISO_XA_C
extern int read_iso_info(FILE *in, ISO_INFO *out);
extern int open_iso_file(char *in, ISO_INFO *out);
extern int close_iso_file(ISO_INFO *iso);
#endif

#ifdef  __cplusplus
}
#endif

#endif