#include <stdio.h>
#include <string.h>
#include <ctype.h>

#define FILENAME_C
#include "filename.h"

#ifdef __WIN32__
#define PATH_DELIMITER '\\'
#else
#define PATH_DELIMITER '/'
#endif

int check_sfx(char *filepath, char *sfx);
int compare_directory(char *s1, char *s2);
int compare_drive(char *s1, char *s2);

char *read_filename(char *filepath);
char *read_sfx(char *filepath);

char *get_directory(char *filepath);
char *get_filename(char *filepath);
char *get_sfx(char *filepath);
char *get_basename(char *filepath);

char *change_filename(char *filepath, char *filename);
char *change_sfx(char *filepath, char *sfx);

int cut_filename(char *filepath);
int cut_sfx(char *filepath);

int cut_tail_digits(char *string);
int cut_tail_underber(char *string);
int cut_tail_path_delimiter(char *string);
int cut_tail_separater(char *string);

int has_separable_tail_num(char *string);

int file_exists(char *filename);

int check_sfx(char *filename, char *suffix)
{
	int i,n,r;
	int fname_len;

	char *w1, *w2;

	fname_len = (int)strlen(filename);
	n = (int)strlen(suffix);

	w1 = (char *)calloc(n+1,1);
	w2 = (char *)calloc(n+1,1);

	for(i=0;i<n;i++){
		w1[i] = (char)tolower(filename[fname_len - n + i]);
		w2[i] = (char)tolower(suffix[i]);
	}

	if(strcmp(w1, w2) == 0){
		r = 1;
	}else{
		r = 0;
	}

	free(w1);
	free(w2);

	return r;
}

int compare_directory(char *s1, char *s2)
{
    int r;
    char *w1, *w2;

    w1 = get_directory(s1);
    w2 = get_directory(s2);

    if(strcmp(w1, w2) == 0){
        r = 1;
    }else{
        r = 0;
    }

    free(w1);
    free(w2);

    return r;
}

int compare_drive(char *s1, char *s2)
{
    if(toupper(s1[0]) == toupper(s2[0])){
        return 1;
    }else{
        return 0;
    };
}

char *read_filename(char *filepath)
{
	int i;

	for(i=(int)strlen(filepath);i>0;i--){
		if(filepath[i] == PATH_DELIMITER){
			return filepath + i + 1;
		}
	}

	return filepath;
}

char *read_sfx(char *filepath)
{
	int i,n;

	n = (int)strlen(filepath);
	for(i=n;i>0;i--){
		if(filepath[i] == '.'){
			return filepath + i; /* suffix include '.' */
		}else if(filepath[i] == PATH_DELIMITER){
			break; /* filepath have no suffix */
		}
	}

	return filepath + n;
}

char *get_directory(char *filepath)
{
	int n;
	char *r;

	n = (int)strlen(filepath) + 1;
	r = malloc(n);
	memcpy(r, filepath, n);

	cut_filename(r);

	return r;
}

char *get_filename(char *filepath)
{
	int n;
	char *r;
	char *work;

	work = read_filename(filepath);
	n = (int)strlen(work) + 1;
	r = malloc(n);
	memcpy(r, work, n);

	return r;
}

char *get_sfx(char *filepath)
{
	int n;
	char *r;
	char *work;

	work = read_sfx(filepath);
	n = (int)strlen(work) + 1;
	r = malloc(n);
	memcpy(r, work, n);

	return r;
}

char *get_basename(char *filepath)
{
	char *r;

	r = get_filename(filepath);
	cut_sfx(r);

	return r;
}

int cut_filename(char *filepath)
{
	int i,n;

	n = (int)strlen(filepath);
	if(!n){
		return 0;
	}
	
	for(i=n-1;i>0;i--){
//		if(filepath[i] == PATH_DELIMITER){
		if(filepath[i] == '\\'){
			i += 1;
			break;
		}
	}

	filepath[i] = '\0';

	return (n - i);
}

int cut_sfx(char *filepath)
{
	int i,n;

	n = (int)strlen(filepath);
	if(!n){
		return 0;
	}
	
	for(i=n-1;i>0;i--){
		if(filepath[i] == '.'){
			break;
		}else if(filepath[i] == PATH_DELIMITER){
			i = n;
			break; /* filepath have no suffix */
		}
	}

	filepath[i] = '\0';

	return (n - i);
}

char *change_filename(char *filepath, char *filename)
{
	int i,n;
	char *work;

	n = (int)strlen(filepath) + 1;

	work = (char *)malloc(n + strlen(filename));

	memcpy(work, filepath, n);

	for(i=n-1;i>0;i--){
		if(work[i] == PATH_DELIMITER){
			break;
		}
	}
	work[i] = '\0';

	strcat(work, filename);

	return work;
}

char *change_sfx(char *filepath, char *sfx)
{
	int i,n;
	char *work;

	n = (int)strlen(filepath);

	work = (char *)malloc(n + strlen(sfx) + 1);

	memcpy(work, filepath, n);

	for(i=n-1;i>0;i--){
		if(work[i] == '.'){
			work[i] = '\0';
			break;
		}else if(work[i] == PATH_DELIMITER){
			/* filepath has no suffix, add suffix */
			break;
		}
	}

	strcat(work, sfx);

	return work;
}

int cut_tail_digits(char *string)
{
    int i,n;

    n = (int)strlen(string) - 1;

    for(i=n;i>0;i--){
        if(isdigit(string[i])){
            string[i] = '\0';
        }else{
            break;
        }
    }

    return (n - i);
}

int cut_tail_underbars(char *string)
{
	int i,n;

	n = (int)strlen(string) - 1;

	for(i=n;i>0;i--){
		if(string[i] == '_'){
			string[i] = '\0';
		}else{
			break;
		}
	}

	return (n - i);
}

int cut_tail_path_delimiter(char *string)
{
	int n;

	n = (int)strlen(string) - 1;

	if(string[n] == PATH_DELIMITER){
		string[n] = '\0';
        return 1;
	}
	return 0;
}

int cut_tail_separater(char *string)
{
	int n;

	n = (int)strlen(string) - 1;

	switch(string[n]){
	case '_':
	case '-':
	case '~':
	case ' ':
	case '%':
	case ':':
		string[n] = '\0';
		return 1;
	default:
		return 0;
	}
}

int has_separable_tail_num(char *string)
{
	int r;
	int n,m;
	char *work;

	n = (int)strlen(string)+1;

	work = (char *)malloc(n);
	memcpy(work, string, n);

	r = 0;

	m = cut_tail_digits(work);
	if(m){
		if(cut_tail_separater(work)){
			r = 1;
		}else if((m == 3) && (string[n-m-1] == '0')){
			r = 1;
		}
	}
	
	free(work);
	return r;
}

int file_exists(char *filename)
{
	FILE *test;

	test = fopen(filename, "rb");
	if(test == NULL){
		return 0;
	}

	fclose(test);

	return 1;
}