/*
** Padus Disc Juggler image file (CDI) treating module
**
** Writen by Sakae Tatibana <tatibana@extra.hu>
**
** 2000, 7/29 - coding start
**      10/19 - 3.00.730 support 
*/

#include <string.h>
#include "binary.h"
#include "fcd_basic.h"

#define CDI_C
#include "cdi.h"

typedef struct {
	unsigned char marker[8];
	int unknown_a;
	unsigned char filename_length;
	unsigned char filename[FILENAME_MAX];
	int unknown_b;
	int unknown_c;
	int unknown_d;
	int unknown_e;
	short unknown_f;
	int pregap;
	int length;
	int unknown_g;
	short unknown_h;
	short unknown_i;
	int mode;
	int unknown_j;
	int session;
	int track;
	int start;
	int total;
	int unknown_k;
	int unknown_l;
	int unknown_m;
	int unknown_n;
	unsigned char control;
	int unknown_o;
	int block_size;
	int unknown_p;
	int total_b;
	int unknown_q;
	int unknown_r;
	int unknown_s;
	int unknown_t;
} V1_01_199_TRACK;

typedef struct {
	unsigned char marker[20];
	int unknown_a;
	unsigned char filename_length;
	unsigned char filename[FILENAME_MAX];
	int unknown_b;
	int unknown_c;
	int unknown_d;
	int unknown_e;
	short unknown_f;
	int pregap;
	int length;
	int unknown_g;
	short unknown_h;
	short unknown_i;
	int mode;
	int unknown_j;
	int unknown_k;
	int track;
	int start;
	int total;
	int unknown_l;
	int unknown_m;
	int unknown_n;
	char control;
	int unknown_o;
	int block_size;
	int unknown_p;
	int total_b;
	int unknown_q;
	int unknown_r;
	int unknown_s;
	int unknown_t;
	short unknown_u;
} V1_05_340_TRACK;

typedef struct {
	unsigned char marker[20];
	int unknown_a;
	unsigned char filename_length;
	unsigned char filename[FILENAME_MAX];
	int unknown_b;
	int unknown_c;
	int unknown_d;
	int unknown_e;
	int unknown_f;
	short unknown_g;
	int pregap;
	int length;
	int unknown_h;
	int mode;
	int unknown_i;
	int unknown_j;
	int track;
	int start;
	int total;
	int unknown_k;
	int unknown_l;
	int unknown_m;
	unsigned char control;
	int unknown_n;
	int block_size;
	int unknown_o;
	int total_b;
	int unknown_p;
	int unknown_q;
	int unknown_r;
	int unknown_s;
	int unknown_t;
} V1_05_395_TRACK;

typedef struct {
	unsigned char marker[20];
	int unknown_a;
	unsigned char filename_length;
	unsigned char filename[FILENAME_MAX];
	char unknown_b;
	short unknown_c;
	int unknown_d;
	int unknown_e;
	int unknown_f;
	int unknown_g;
	int unknown_h;
	short unknown_i;
	int pregap;
	int length;
	int unknown_j;
	short unknown_k;
	int mode;
	int unknown_l;
	int unknown_m;
	int track;
	int start;
	int total;
	int unknown_n;
	int unknown_o;
	int unknown_p;
	int unknown_q;
	int block_size;
	unsigned char control;
	int unknown_r;
	int total_b;
	int unknown_s;
	int unknown_t;
	int unknown_u;
	int unknown_v;
	int unknown_w;
	int unknown_x;
} V2_00_409_TRACK;

typedef struct {
	unsigned char marker[20];
	int unknown_a;
	unsigned char filename_length;
	unsigned char filename[FILENAME_MAX];
	char unknown_b;
	short unknown_c;
	int unknown_d;
	int unknown_e;
	int unknown_f;
	int unknown_g;
	int unknown_h;
	short unknown_i;
	int pregap;
	int length;
	int unknown_j;
	short unknown_k;
	int mode;
	int unknown_l;
	int unknown_m;
	int track;
	int start;
	int total;
	int unknown_n;
	int unknown_o;
	int unknown_p;
	int unknown_q;
	int block_size;
	unsigned char control;
	int unknown_r;
	int total_b;
	int unknown_s;
	int unknown_t;
	int unknown_u;
	int unknown_v;
	int unknown_w;
	unsigned char unknown_x;
	unsigned char end_marker[8];
	int unknown_y;
} V3_00_730_TRACK;

typedef struct {
	unsigned char marker[20];
	int unknown_a;
	unsigned char filename_length;
	unsigned char filename[FILENAME_MAX];
	char unknown_b;
	short unknown_c;
	int unknown_d;
	int unknown_e;
	int unknown_f;
	int unknown_g;
	int unknown_h;
	short unknown_i;
	int pregap;
	int length;
	int unknown_j;
	short unknown_k;
	int mode;
	int unknown_l;
	int unknown_m;
	int track;
	int start;
	int total;
	int unknown_n;
	int unknown_o;
	int unknown_p;
	int unknown_q;
	int block_size;
	unsigned char control;
	int unknown_r;
	int total_b;
	int unknown_s;
	int unknown_t;
	int unknown_u;
	int unknown_v;
	int unknown_w;
	unsigned char unknown_x;
	unsigned char end_marker[8];
	int unknown_y;
} V4_TEMP1_TRACK;

typedef struct {
	unsigned char marker[20];
	int unknown_a;
	unsigned char filename_length;
	unsigned char filename[FILENAME_MAX];
	char unknown_b;
	short unknown_c;
	int unknown_d;
	int unknown_e;
	int unknown_f;
	int unknown_g;
	int unknown_h;
	short unknown_i;
	int pregap;
	int length;
	int unknown_j;
	short unknown_k;
	int mode;
	int unknown_l;
	int unknown_m;
	int track;
	int start;
	int total;
	int unknown_n;
	int unknown_o;
	int unknown_p;
	int unknown_q;
	int block_size;
	unsigned char control;
	int unknown_r;
	int total_b;
	int unknown_s;
	int unknown_t;
	int unknown_u;
	int unknown_v;
	int unknown_w;
	unsigned char unknown_x;
	unsigned char end_marker[8];
	int unknown_y;
} V4_TEMP2_TRACK;

typedef struct {
	unsigned char marker[20];
	int unknown_a;
	unsigned char filename_length;
	unsigned char filename[FILENAME_MAX];
	char unknown_b;
	short unknown_c;
	int unknown_d;
	int unknown_e;
	int unknown_f;
	int unknown_g;
	int unknown_h;
	short unknown_i;
	int pregap;
	int length;
	int unknown_j;
	short unknown_k;
	int mode;
	int unknown_l;
	int unknown_m;
	int track;
	int start;
	int total;
	int unknown_n;
	int unknown_o;
	int unknown_p;
	int unknown_q;
	int block_size;
	unsigned char control;
	int unknown_r;
	int total_b;
	int unknown_s;
	int unknown_t;
	int unknown_u;
	int unknown_v;
	int unknown_w;
	unsigned char unknown_x;
	unsigned char end_marker[8];
	int unknown_y;
} V4_TEMP3_TRACK;


extern "C" int open_cdi_file(char *path, DAO_INFO *out);

static int open_v1_01_199(char *path, DAO_INFO *out);
static void read_v1_01_199_track(FILE *in, V1_01_199_TRACK *out);

static int open_v1_05_340(char *path, DAO_INFO *out);
static void read_v1_05_340_track(FILE *in, V1_05_340_TRACK *out);

static int open_v1_05_395(char *path, DAO_INFO *out);
static void read_v1_05_395_track(FILE *in, V1_05_395_TRACK *out);

static int open_v2_00_409(char *path, DAO_INFO *out);
static void read_v2_00_409_track(FILE *in, V2_00_409_TRACK *out);

static int open_v3_00_730(char *path, DAO_INFO *out);
static void read_v3_00_730_track(FILE *in, V3_00_730_TRACK *out);

static int open_v4_temp1(char *path, DAO_INFO *out);
static void read_v4_temp1_track(FILE *in, V4_TEMP1_TRACK *out);

static int open_v4_temp2(char *path, DAO_INFO *out);
static void read_v4_temp2_track(FILE *in, V4_TEMP2_TRACK *out);

static int open_v4_temp3(char *path, DAO_INFO *out);
static void read_v4_temp3_track(FILE *in, V4_TEMP3_TRACK *out);

int open_cdi_file(char *path, DAO_INFO *out)
{
	int r;

	if(open_v4_temp3(path, out)){
		r = 1;
	}else if(open_v4_temp2(path, out)){
		r = 1;
	}else if(open_v4_temp1(path, out)){
		r = 1;
	}else if(open_v3_00_730(path, out)){
		r = 1;
	}else if(open_v2_00_409(path, out)){
		r = 1;
	}else if(open_v1_05_395(path, out)){
		r = 1;
	}else if(open_v1_05_340(path, out)){
		r = 1;
	}else if(open_v1_01_199(path, out)){
		r = 1;
	}else{
		r = 0;
	}

	return r;
}

static int open_v1_01_199(char *path, DAO_INFO *out)
{
	int i,j,n,w;

	short session, track;
	int offset_comp;
	int previous_session_last;

	V1_01_199_TRACK work;

	FILE *stream;

	static const unsigned char marker[] = {
		0, 0, 0, 0, 255, 255, 255, 255,
	};

	memset(out, 0, sizeof(DAO_INFO));
	memset(&work, 0, sizeof(V1_01_199_TRACK));

	stream = fopen(path, "rb");
	if(stream == NULL){
		return 0;
	}

	fseek(stream, -4, SEEK_END);
	read_le_int32(stream, &n);
	fseek(stream, n, SEEK_SET);

	read_le_int16(stream, &session);
	if (0 == session || session >= 100){
		return 0;
	}

	out->path = path;
	out->num_of_track = 0;

	offset_comp = 0;
	previous_session_last = 0;
	for(i=0;i<session;i++){
		read_le_int16(stream, &track);
		for(j=0;j<track;j++){
			read_v1_01_199_track(stream, &work);
			if(memcmp(work.marker, marker, 8)){
				fclose(stream);
				return 0;
			}
			n = out->num_of_track;
			out->num_of_track += 1;
			out->track[n].index = n;
			strcpy(out->track[n].path, path);

			switch(work.mode){
			case 0:
				out->track[n].type = DAO_TRACK_TYPE_AUDIO;
				break;
			case 1:
				out->track[n].type = DAO_TRACK_TYPE_MODE1;
				break;
			case 2:
				out->track[n].type = DAO_TRACK_TYPE_MODE2;
				break;
			default:
				fclose(stream);
				return 0;
			}

			switch(work.block_size){
			case 0:
				out->track[n].block_size = 2048;
				break;
			case 1:
				out->track[n].block_size = 2336;
				break;
			case 3:
				out->track[n].block_size = 2352;
				break;
			case 5:
				out->track[n].block_size = 2448;
				break;
			default:
				fclose(stream);
				return 0;
			}

			if(j == 0){
				offset_comp += (work.start - previous_session_last) * 2352;
			}
			out->track[n].offset = work.start * 2352 + work.pregap * out->track[n].block_size - offset_comp;

			out->track[n].start = work.start + work.pregap - 150;

			out->track[n].num_of_block = work.length;

			offset_comp += (int)((2352 - out->track[n].block_size) * work.total);

			if(work.total != work.total_b || !work.total){
				fclose(stream);
				return 0;
			}
		}
		previous_session_last = work.start + work.total;
		read_le_int32(stream, &w);
		read_le_int32(stream, &w);
		read_le_int32(stream, &w);
	}

	fclose(stream);

	return 1;
}

static void read_v1_01_199_track(FILE *in, V1_01_199_TRACK *out)
{
	fread(out->marker, 1, 8, in);
	read_le_int32(in, &(out->unknown_a));

	out->filename_length = (unsigned char)fgetc(in);
	fread(out->filename, 1, out->filename_length, in);

	read_le_int32(in, &(out->unknown_b));
	read_le_int32(in, &(out->unknown_c));
	read_le_int32(in, &(out->unknown_d));
	read_le_int32(in, &(out->unknown_e));
	read_le_int16(in, &(out->unknown_f));

	read_le_int32(in, &(out->pregap));
	read_le_int32(in, &(out->length));

	read_le_int32(in, &(out->unknown_g));
	read_le_int16(in, &(out->unknown_h));
	read_le_int16(in, &(out->unknown_i));

	read_le_int32(in, &(out->mode));

	read_le_int32(in, &(out->unknown_j));

	read_le_int32(in, &(out->session));
	read_le_int32(in, &(out->track));
	read_le_int32(in, &(out->start));
	read_le_int32(in, &(out->total));

	read_le_int32(in, &(out->unknown_k));
	read_le_int32(in, &(out->unknown_l));
	read_le_int32(in, &(out->unknown_m));
	read_le_int32(in, &(out->unknown_n));

	out->control = (unsigned char)fgetc(in);

	read_le_int32(in, &(out->unknown_o));

	read_le_int32(in, &(out->block_size));

	read_le_int32(in, &(out->unknown_p));

	read_le_int32(in, &(out->total_b));

	read_le_int32(in, &(out->unknown_q));
	read_le_int32(in, &(out->unknown_r));
	read_le_int32(in, &(out->unknown_s));
	read_le_int32(in, &(out->unknown_t));
}

static int open_v1_05_340(char *path, DAO_INFO *out)
{
	int i,j,n;
	
	short session, track;
	int offset_comp;
	int previous_session_last;

	int w32;
	short w16;
	
	V1_05_340_TRACK work;
	
	FILE *stream;

	static const unsigned char marker[] = {
		0, 0, 0, 0,
		1, 0, 0, 0, 255, 255, 255, 255,
		1, 0, 0, 0, 255, 255, 255, 255,
	};

	memset(out, 0, sizeof(DAO_INFO));
	memset(&work, 0, sizeof(V1_05_340_TRACK));

	stream = fopen(path, "rb");
	if(stream == NULL){
		return 0;
	}

	fseek(stream, -4, SEEK_END);
	read_le_int32(stream, &n);
	fseek(stream, n, SEEK_SET);

	read_le_int16(stream, &session);
	if (0 == session || session >= 100){
		return 0;
	}

	out->path = path;
	out->num_of_track = 0;
	
	offset_comp = 0;
	previous_session_last = 0;
	for(i=0;i<session;i++){
		read_le_int16(stream, &track);
		read_le_int16(stream, &w16);
		for(j=0;j<track;j++){
			read_v1_05_340_track(stream, &work);
			if(memcmp(work.marker, marker, 20)){
				fclose(stream);
				return 0;
			}
			n = out->num_of_track;
			out->num_of_track += 1;
			out->track[n].index = n;
			strcpy(out->track[n].path, path);

			switch(work.mode){
			case 0:
				out->track[n].type = DAO_TRACK_TYPE_AUDIO;
				break;
			case 1:
				out->track[n].type = DAO_TRACK_TYPE_MODE1;
				break;
			case 2:
				out->track[n].type = DAO_TRACK_TYPE_MODE2;
				break;
			default:
				fclose(stream);
				return 0;
			}

			switch(work.block_size){
			case 0:
				out->track[n].block_size = 2048;
				break;
			case 1:
				out->track[n].block_size = 2336;
				break;
			case 2:
				out->track[n].block_size = 2352;
				break;
			default:
				out->track[n].block_size = 2448;
			}

			if(j == 0){
				offset_comp += (work.start - previous_session_last) * 2352;
			}
			out->track[n].offset = work.start * 2352 + work.pregap * out->track[n].block_size - offset_comp;

			out->track[n].start = work.start + work.pregap - 150;
			
			out->track[n].num_of_block = work.length;
			
			offset_comp += (int)((2352 - out->track[n].block_size) * work.total);

			if(work.total != work.total_b || !work.total){
				fclose(stream);
				return 0;
			}
		}
		previous_session_last = work.start + work.total;
		read_le_int16(stream, &w16);
		read_le_int32(stream, &w32);
		read_le_int32(stream, &w32);
		read_le_int32(stream, &w32);
	}

	fclose(stream);

	return 1;
}

static void read_v1_05_340_track(FILE *in, V1_05_340_TRACK *out)
{
	fread(out->marker, 1, 20, in);
	read_le_int32(in, &(out->unknown_a));

	out->filename_length = (unsigned char)fgetc(in);
	fread(out->filename, 1, out->filename_length, in);

	read_le_int32(in, &(out->unknown_b));
	read_le_int32(in, &(out->unknown_c));
	read_le_int32(in, &(out->unknown_d));
	read_le_int32(in, &(out->unknown_e));
	read_le_int16(in, &(out->unknown_f));

	read_le_int32(in, &(out->pregap));
	read_le_int32(in, &(out->length));

	read_le_int32(in, &(out->unknown_g));
	read_le_int16(in, &(out->unknown_h));
	read_le_int16(in, &(out->unknown_i));

	read_le_int32(in, &(out->mode));

	read_le_int32(in, &(out->unknown_j));
	read_le_int32(in, &(out->unknown_k));

	read_le_int32(in, &(out->track));
	read_le_int32(in, &(out->start));
	read_le_int32(in, &(out->total));

	read_le_int32(in, &(out->unknown_l));
	read_le_int32(in, &(out->unknown_m));
	read_le_int32(in, &(out->unknown_n));

	out->control = (char)fgetc(in);

	read_le_int32(in, &(out->unknown_o));

	read_le_int32(in, &(out->block_size));

	read_le_int32(in, &(out->unknown_p));

	read_le_int32(in, &(out->total_b));

	read_le_int32(in, &(out->unknown_q));
	read_le_int32(in, &(out->unknown_r));
	read_le_int32(in, &(out->unknown_s));
	read_le_int32(in, &(out->unknown_t));
	read_le_int16(in, &(out->unknown_u));
}

static int open_v1_05_395(char *path, DAO_INFO *out)
{
	int i,j,n,w;
	
	short session, track;
	int offset_comp;
	int previous_session_last;
	
	V1_05_395_TRACK work;
	
	FILE *stream;

	static const unsigned char marker[] = {
		0, 0, 1, 0, 0, 0, 255, 255, 255, 255,
		0, 0, 1, 0, 0, 0, 255, 255, 255, 255,
	};

	memset(out, 0, sizeof(DAO_INFO));
	memset(&work, 0, sizeof(V1_05_395_TRACK));

	stream = fopen(path, "rb");
	if(stream == NULL){
		return 0;
	}

	fseek(stream, -4, SEEK_END);
	read_le_int32(stream, &n);
	fseek(stream, n, SEEK_SET);

	read_le_int16(stream, &session);
	if (0 == session || session >= 100){
		return 0;
	}

	out->path = path;
	out->num_of_track = 0;
	
	offset_comp = 0;
	previous_session_last = 0;
	for(i=0;i<session;i++){
		read_le_int16(stream, &track);
		read_le_int32(stream, &w);
		for(j=0;j<track;j++){
			read_v1_05_395_track(stream, &work);
			if(memcmp(work.marker, marker, 20)){
				fclose(stream);
				return 0;
			}
			n = out->num_of_track;
			out->num_of_track += 1;
			out->track[n].index = n;
			strcpy(out->track[n].path, path);

			switch(work.mode){
			case 0:
				out->track[n].type = DAO_TRACK_TYPE_AUDIO;
				break;
			case 1:
				out->track[n].type = DAO_TRACK_TYPE_MODE1;
				break;
			case 2:
				out->track[n].type = DAO_TRACK_TYPE_MODE2;
				break;
			default:
				fclose(stream);
				return 0;
			}

			switch(work.block_size){
			case 0:
				out->track[n].block_size = 2048;
				break;
			case 1:
				out->track[n].block_size = 2336;
				break;
			case 2:
				out->track[n].block_size = 2352;
				break;
			case 4:
				out->track[n].block_size = 2448;
				break;
			default:
				fclose(stream);
				return 0;
			}

			if(j == 0){
				offset_comp += (work.start - previous_session_last) * 2352;
			}
			out->track[n].offset = work.start * 2352 + work.pregap * out->track[n].block_size - offset_comp;

			out->track[n].start = work.start + work.pregap - 150;
			
			out->track[n].num_of_block = work.length;
			
			offset_comp += (int)((2352 - out->track[n].block_size) * work.total);

			if(work.total != work.total_b || !work.total){
				fclose(stream);
				return 0;
			}
		}
		previous_session_last = work.start + work.total;
		read_le_int32(stream, &w);
		read_le_int32(stream, &w);
		read_le_int32(stream, &w);
	}

	fclose(stream);

	return 1;
}

static void read_v1_05_395_track(FILE *in, V1_05_395_TRACK *out)
{
	fread(out->marker, 1, 20, in);
	read_le_int32(in, &(out->unknown_a));

	out->filename_length = (unsigned char)fgetc(in);
	fread(out->filename, 1, out->filename_length, in);

	read_le_int32(in, &(out->unknown_b));
	read_le_int32(in, &(out->unknown_c));
	read_le_int32(in, &(out->unknown_d));
	read_le_int32(in, &(out->unknown_e));
	read_le_int32(in, &(out->unknown_f));
	read_le_int16(in, &(out->unknown_g));

	read_le_int32(in, &(out->pregap));
	read_le_int32(in, &(out->length));

	read_le_int32(in, &(out->unknown_h));

	read_le_int32(in, &(out->mode));

	read_le_int32(in, &(out->unknown_i));
	read_le_int32(in, &(out->unknown_j));


	read_le_int32(in, &(out->track));
	read_le_int32(in, &(out->start));
	read_le_int32(in, &(out->total));

	read_le_int32(in, &(out->unknown_k));
	read_le_int32(in, &(out->unknown_l));
	read_le_int32(in, &(out->unknown_m));

	out->control = (unsigned char)fgetc(in);

	read_le_int32(in, &(out->unknown_n));

	read_le_int32(in, &(out->block_size));

	read_le_int32(in, &(out->unknown_o));

	read_le_int32(in, &(out->total_b));

	read_le_int32(in, &(out->unknown_p));
	read_le_int32(in, &(out->unknown_q));
	read_le_int32(in, &(out->unknown_r));
	read_le_int32(in, &(out->unknown_s));
	read_le_int32(in, &(out->unknown_t));
}

static int open_v2_00_409(char *path, DAO_INFO *out)
{
	int i,j,n,w;
	
	short session, track;
	int offset_comp;
	int previous_session_last;
	
	V2_00_409_TRACK work;
	
	FILE *stream;

	static const unsigned char marker[] = {
		0, 0, 1, 0, 0, 0, 255, 255, 255, 255,
		0, 0, 1, 0, 0, 0, 255, 255, 255, 255,
	};

	memset(out, 0, sizeof(DAO_INFO));
	memset(&work, 0, sizeof(V2_00_409_TRACK));

	stream = fopen(path, "rb");
	if(stream == NULL){
		return 0;
	}

	fseek(stream, -4, SEEK_END);
	read_le_int32(stream, &n);
	fseek(stream, n, SEEK_SET);

	read_le_int16(stream, &session);
	if (0 == session || session >= 100){
		return 0;
	}

	out->path = path;
	out->num_of_track = 0;
	
	offset_comp = 0;
	previous_session_last = 0;
	for(i=0;i<session;i++){
		read_le_int16(stream, &track);
		read_le_int32(stream, &w);
		for(j=0;j<track;j++){
			read_v2_00_409_track(stream, &work);
			if(memcmp(work.marker, marker, 20)){
				fclose(stream);
				return 0;
			}
			n = out->num_of_track;
			out->num_of_track += 1;
			out->track[n].index = n;
			strcpy(out->track[n].path, path);

			switch(work.mode){
			case 0:
				out->track[n].type = DAO_TRACK_TYPE_AUDIO;
				break;
			case 1:
				out->track[n].type = DAO_TRACK_TYPE_MODE1;
				break;
			case 2:
				out->track[n].type = DAO_TRACK_TYPE_MODE2;
				break;
			default:
				fclose(stream);
				return 0;
			}

			switch(work.block_size){
			case 0:
				out->track[n].block_size = 2048;
				break;
			case 1:
				out->track[n].block_size = 2336;
				break;
			case 2:
				out->track[n].block_size = 2352;
				break;
			case 4:
				out->track[n].block_size = 2448;
				break;
			default:
				fclose(stream);
				return 0;
			}

			if(j == 0){
				offset_comp += (work.start - previous_session_last) * 2352;
			}
			out->track[n].offset = work.start * 2352 + work.pregap * out->track[n].block_size - offset_comp;

			out->track[n].start = work.start + work.pregap - 150;
			
			out->track[n].num_of_block = work.length;
			
			offset_comp += (int)((2352 - out->track[n].block_size) * work.total);

			if(work.total != work.total_b || !work.total){
				fclose(stream);
				return 0;
			}
		}
		previous_session_last = work.start + work.total;
		read_le_int32(stream, &w);
		read_le_int32(stream, &w);
	}

	fclose(stream);

	return 1;
}

static void read_v2_00_409_track(FILE *in, V2_00_409_TRACK *out)
{
	fread(out->marker, 1, 20, in);
	read_le_int32(in, &(out->unknown_a));

	out->filename_length = (unsigned char)fgetc(in);
	fread(out->filename, 1, out->filename_length, in);

	out->unknown_b = (unsigned char)fgetc(in);
	read_le_int16(in, &(out->unknown_c));
	read_le_int32(in, &(out->unknown_d));
	read_le_int32(in, &(out->unknown_e));
	read_le_int32(in, &(out->unknown_f));
	read_le_int32(in, &(out->unknown_g));
	read_le_int32(in, &(out->unknown_h));
	read_le_int16(in, &(out->unknown_i));

	read_le_int32(in, &(out->pregap));
	read_le_int32(in, &(out->length));

	read_le_int32(in, &(out->unknown_j));
	read_le_int16(in, &(out->unknown_k));

	read_le_int32(in, &(out->mode));

	read_le_int32(in, &(out->unknown_l));
	read_le_int32(in, &(out->unknown_m));


	read_le_int32(in, &(out->track));
	read_le_int32(in, &(out->start));
	read_le_int32(in, &(out->total));

	read_le_int32(in, &(out->unknown_n));
	read_le_int32(in, &(out->unknown_o));
	read_le_int32(in, &(out->unknown_p));
	read_le_int32(in, &(out->unknown_q));

	read_le_int32(in, &(out->block_size));
	out->control = (unsigned char)fgetc(in);

	read_le_int32(in, &(out->unknown_r));

	read_le_int32(in, &(out->total_b));

	read_le_int32(in, &(out->unknown_s));
	read_le_int32(in, &(out->unknown_t));
	read_le_int32(in, &(out->unknown_u));
	read_le_int32(in, &(out->unknown_v));
	read_le_int32(in, &(out->unknown_w));
	read_le_int32(in, &(out->unknown_x));
}

static int open_v3_00_730(char *path, DAO_INFO *out)
{
	int i,j,n,w;
	
	short session, track;
	int offset_comp;
	int previous_session_last;
	
	V3_00_730_TRACK work;
	
	FILE *stream;

	char junk[7];

	static const unsigned char marker[] = {
		0, 0, 1, 0, 0, 0, 255, 255, 255, 255,
		0, 0, 1, 0, 0, 0, 255, 255, 255, 255,
	};

	memset(out, 0, sizeof(DAO_INFO));
	memset(&work, 0, sizeof(V3_00_730_TRACK));

	stream = fopen(path, "rb");
	if(stream == NULL){
		return 0;
	}

	fseek(stream, -4, SEEK_END);
	read_le_int32(stream, &n);
	fseek(stream, n, SEEK_SET);

	read_le_int16(stream, &session);
	if (0 == session || session >= 100){
		return 0;
	}

	out->path = path;
	out->num_of_track = 0;
	
	offset_comp = 0;
	previous_session_last = 0;
	for(i=0;i<session;i++){
		read_le_int16(stream, &track);
		read_le_int32(stream, &w);
		for(j=0;j<track;j++){
			read_v3_00_730_track(stream, &work);
			if(memcmp(work.marker, marker, 20)){
				fclose(stream);
				return 0;
			}
			n = out->num_of_track;
			out->num_of_track += 1;
			out->track[n].index = n;
			strcpy(out->track[n].path, path);

			switch(work.mode){
			case 0:
				out->track[n].type = DAO_TRACK_TYPE_AUDIO;
				break;
			case 1:
				out->track[n].type = DAO_TRACK_TYPE_MODE1;
				break;
			case 2:
				out->track[n].type = DAO_TRACK_TYPE_MODE2;
				break;
			default:
				fclose(stream);
				return 0;
			}

			switch(work.block_size){
			case 0:
				out->track[n].block_size = 2048;
				break;
			case 1:
				out->track[n].block_size = 2336;
				break;
			case 2:
				out->track[n].block_size = 2352;
				break;
			case 4:
				out->track[n].block_size = 2448;
				break;
			default:
				fclose(stream);
				return 0;
			}

			if(j == 0){
				offset_comp += (work.start - previous_session_last) * 2352;
			}
			out->track[n].offset = work.start * 2352 + work.pregap * out->track[n].block_size - offset_comp;

			out->track[n].start = work.start + work.pregap - 150;
			
			out->track[n].num_of_block = work.length;
			
			offset_comp += (int)((2352 - out->track[n].block_size) * work.total);

			if(work.total != work.total_b || !work.total){
				fclose(stream);
				return 0;
			}
		}
		previous_session_last = work.start + work.total;
		fread(junk, 1, 7, stream);
	}

	fclose(stream);

	return 1;
}

static void read_v3_00_730_track(FILE *in, V3_00_730_TRACK *out)
{
	fread(out->marker, 1, 20, in);

	read_le_int32(in, &(out->unknown_a));

	out->filename_length = (unsigned char)fgetc(in);
	fread(out->filename, 1, out->filename_length, in);

	out->unknown_b = (char)fgetc(in);
	read_le_int16(in, &(out->unknown_c));
	
	read_le_int32(in, &(out->unknown_d));
	read_le_int32(in, &(out->unknown_e));
	read_le_int32(in, &(out->unknown_f));
	read_le_int32(in, &(out->unknown_g));
	read_le_int32(in, &(out->unknown_h));

	read_le_int16(in, &(out->unknown_i));

	read_le_int32(in, &(out->pregap));
	read_le_int32(in, &(out->length));

	read_le_int32(in, &(out->unknown_j));

	read_le_int16(in, &(out->unknown_k));

	read_le_int32(in, &(out->mode));

	read_le_int32(in, &(out->unknown_l));
	read_le_int32(in, &(out->unknown_m));

	read_le_int32(in, &(out->track));
	read_le_int32(in, &(out->start));
	read_le_int32(in, &(out->total));

	read_le_int32(in, &(out->unknown_n));
	read_le_int32(in, &(out->unknown_o));
	read_le_int32(in, &(out->unknown_p));
	read_le_int32(in, &(out->unknown_q));
	
	read_le_int32(in, &(out->block_size));

	out->control = (unsigned char)fgetc(in);

	read_le_int32(in, &(out->unknown_r));
	
	read_le_int32(in, &(out->total_b));

	read_le_int32(in, &(out->unknown_s));
	read_le_int32(in, &(out->unknown_t));
	read_le_int32(in, &(out->unknown_u));
	read_le_int32(in, &(out->unknown_v));
	read_le_int32(in, &(out->unknown_w));

	out->unknown_x = (unsigned char)fgetc(in);

	fread(out->end_marker, 1, 8, in);

	read_le_int32(in, &(out->unknown_y));
}

static int open_v4_temp1(char *path, DAO_INFO *out)
{
	int i,j,n,w;
	
	short session, track;
	int offset_comp;
	int previous_session_last;
	
	V4_TEMP1_TRACK work;
	
	FILE *stream;

	char junk[9];

	static const unsigned char marker[] = {
		0, 0, 1, 0, 0, 0, 255, 255, 255, 255,
		0, 0, 1, 0, 0, 0, 255, 255, 255, 255,
	};

	memset(out, 0, sizeof(DAO_INFO));
	memset(&work, 0, sizeof(V4_TEMP1_TRACK));

	stream = fopen(path, "rb");
	if(stream == NULL){
		return 0;
	}

	fseek(stream, -4, SEEK_END);
	read_le_int32(stream, &n);
	fseek(stream, -n, SEEK_END);

	read_le_int16(stream, &session);
	if (0 == session || session >= 100){
		fclose(stream);
		return 0;
	}

	out->path = path;
	out->num_of_track = 0;
	
	offset_comp = 0;
	previous_session_last = 0;
	for(i=0;i<session;i++){
		read_le_int16(stream, &track);
		read_le_int32(stream, &w);
		for(j=0;j<track;j++){
			read_v4_temp1_track(stream, &work);
			if(memcmp(work.marker, marker, 20)){
				fclose(stream);
				return 0;
			}
			n = out->num_of_track;
			out->num_of_track += 1;
			out->track[n].index = n;
			strcpy(out->track[n].path, path);

			switch(work.mode){
			case 0:
				out->track[n].type = DAO_TRACK_TYPE_AUDIO;
				break;
			case 1:
				out->track[n].type = DAO_TRACK_TYPE_MODE1;
				break;
			case 2:
				out->track[n].type = DAO_TRACK_TYPE_MODE2;
				break;
			default:
				fclose(stream);
				return 0;
			}

			switch(work.block_size){
			case 0:
				out->track[n].block_size = 2048;
				break;
			case 1:
				out->track[n].block_size = 2336;
				break;
			case 2:
				out->track[n].block_size = 2352;
				break;
			case 4:
				out->track[n].block_size = 2448;
				break;
			default:
				fclose(stream);
				return 0;
			}

			if(j == 0){
				offset_comp += (work.start - previous_session_last) * 2352;
			}
			out->track[n].offset = work.start * 2352 + work.pregap * out->track[n].block_size - offset_comp;

			out->track[n].start = work.start + work.pregap - 150;
			
			out->track[n].num_of_block = work.length;
			
			offset_comp += (int)((2352 - out->track[n].block_size) * work.total);

			if(work.total != work.total_b || !work.total){
				fclose(stream);
				return 0;
			}
		}
		previous_session_last = work.start + work.total;
		fread(junk, 1, 9, stream);
	}

	fclose(stream);

	return 1;
}

static void read_v4_temp1_track(FILE *in, V4_TEMP1_TRACK *out)
{
	int temp;
	short temp_short;
	fread(out->marker, 1, 20, in);

	read_le_int32(in, &(out->unknown_a));

	out->filename_length = (unsigned char)fgetc(in);
	fread(out->filename, 1, out->filename_length, in);

	temp = fgetc(in);
	read_le_int32(in, &(temp));	
	read_le_int32(in, &(temp));	
	read_le_int32(in, &(temp));	
	read_le_int32(in, &(temp));	
	read_le_int32(in, &(temp));	
	read_le_int32(in, &(temp));	
	read_le_int32(in, &(temp));	
	read_le_int32(in, &(temp));	

	read_le_int32(in, &(out->pregap));
	read_le_int32(in, &(out->length));

	read_le_int32(in, &(out->unknown_j));

	read_le_int16(in, &(out->unknown_k));

	read_le_int32(in, &(out->mode));

	read_le_int32(in, &(out->unknown_l));
	read_le_int32(in, &(out->unknown_m));

	read_le_int32(in, &(out->track));
	read_le_int32(in, &(out->start));
	read_le_int32(in, &(out->total));

	read_le_int32(in, &(out->unknown_n));
	read_le_int32(in, &(out->unknown_o));
	read_le_int32(in, &(out->unknown_p));
	read_le_int32(in, &(out->unknown_q));
	
	read_le_int32(in, &(out->block_size));

	out->control = (unsigned char)fgetc(in);

	read_le_int32(in, &(out->unknown_r));
	
	read_le_int32(in, &(out->total_b));

	read_le_int32(in, &(out->unknown_s));
	read_le_int32(in, &(out->unknown_t));
	read_le_int32(in, &(out->unknown_u));
	read_le_int32(in, &(out->unknown_v));
	read_le_int32(in, &(out->unknown_w));

	out->unknown_x = (unsigned char)fgetc(in);

	fread(out->end_marker, 1, 8, in);

	read_le_int32(in, &(out->unknown_y));

	read_le_int32(in, &(temp));	
	read_le_int32(in, &(temp));	
	read_le_int32(in, &(temp));	
	read_le_int32(in, &(temp));	
	read_le_int32(in, &(temp));	
	read_le_int32(in, &(temp));	
	read_le_int32(in, &(temp));	
	read_le_int32(in, &(temp));	
	read_le_int32(in, &(temp));	
	read_le_int32(in, &(temp));	
	read_le_int32(in, &(temp));	
	read_le_int32(in, &(temp));	
	read_le_int32(in, &(temp));	
	read_le_int32(in, &(temp));	
	read_le_int32(in, &(temp));	
	read_le_int32(in, &(temp));	
	read_le_int32(in, &(temp));	
	read_le_int32(in, &(temp));	
	read_le_int32(in, &(temp));	
	read_le_int16(in, &(temp_short));	
}

static int open_v4_temp2(char *path, DAO_INFO *out)
{
	int i,j,n,w;
	
	short session, track;
	int offset_comp;
	int previous_session_last;
	
	V4_TEMP2_TRACK work;
	
	FILE *stream;

	char junk[11];

	static const unsigned char marker[] = {
		0, 0, 1, 0, 0, 0, 255, 255, 255, 255,
		0, 0, 1, 0, 0, 0, 255, 255, 255, 255,
	};

	memset(out, 0, sizeof(DAO_INFO));
	memset(&work, 0, sizeof(V4_TEMP2_TRACK));

	stream = fopen(path, "rb");
	if(stream == NULL){
		return 0;
	}

	fseek(stream, -4, SEEK_END);
	read_le_int32(stream, &n);
	fseek(stream, -n, SEEK_END);

	read_le_int16(stream, &session);
	if (0 == session || session >= 100){
		fclose(stream);
		return 0;
	}

	out->path = path;
	out->num_of_track = 0;
	
	offset_comp = 0;
	previous_session_last = 0;
	for(i=0;i<session;i++){
		read_le_int16(stream, &track);
		read_le_int32(stream, &w);
		for(j=0;j<track;j++){
			read_v4_temp2_track(stream, &work);
			if(memcmp(work.marker, marker, 20)){
				fclose(stream);
				return 0;
			}
			n = out->num_of_track;
			out->num_of_track += 1;
			out->track[n].index = n;
			strcpy(out->track[n].path, path);

			switch(work.mode){
			case 0:
				out->track[n].type = DAO_TRACK_TYPE_AUDIO;
				break;
			case 1:
				out->track[n].type = DAO_TRACK_TYPE_MODE1;
				break;
			case 2:
				out->track[n].type = DAO_TRACK_TYPE_MODE2;
				break;
			default:
				fclose(stream);
				return 0;
			}

			switch(work.block_size){
			case 0:
				out->track[n].block_size = 2048;
				break;
			case 1:
				out->track[n].block_size = 2336;
				break;
			case 2:
				out->track[n].block_size = 2352;
				break;
			case 4:
				out->track[n].block_size = 2448;
				break;
			default:
				fclose(stream);
				return 0;
			}

			if(j == 0){
				offset_comp += (work.start - previous_session_last) * 2352;
			}
			out->track[n].offset = work.start * 2352 + work.pregap * out->track[n].block_size - offset_comp;

			out->track[n].start = work.start + work.pregap - 150;
			
			out->track[n].num_of_block = work.length;
			
			offset_comp += (int)((2352 - out->track[n].block_size) * work.total);

			if(work.total != work.total_b || !work.total){
				fclose(stream);
				return 0;
			}
		}
		previous_session_last = work.start + work.total;
		fread(junk, 1, 9, stream);
	}

	fclose(stream);

	return 1;
}

static void read_v4_temp2_track(FILE *in, V4_TEMP2_TRACK *out)
{
	int temp;
	char dummy[82];
	fread(out->marker, 1, 20, in);

	read_le_int32(in, &(out->unknown_a));

	out->filename_length = (unsigned char)fgetc(in);
	fread(out->filename, 1, out->filename_length, in);

	temp = (unsigned char)fgetc(in);
	read_le_int32(in, &(temp));	
	read_le_int32(in, &(temp));	
	read_le_int32(in, &(temp));	
	read_le_int32(in, &(temp));	
	read_le_int32(in, &(temp));	
	read_le_int32(in, &(temp));	

	read_le_int32(in, &(out->pregap));
	read_le_int32(in, &(out->length));

	read_le_int32(in, &(out->unknown_j));

	read_le_int16(in, &(out->unknown_k));

	read_le_int32(in, &(out->mode));

	read_le_int32(in, &(out->unknown_l));
	read_le_int32(in, &(out->unknown_m));

	read_le_int32(in, &(out->track));
	read_le_int32(in, &(out->start));
	read_le_int32(in, &(out->total));

	read_le_int32(in, &(out->unknown_n));
	read_le_int32(in, &(out->unknown_o));
	read_le_int32(in, &(out->unknown_p));
	read_le_int32(in, &(out->unknown_q));
	
	read_le_int32(in, &(out->block_size));

	out->control = (unsigned char)fgetc(in);

	read_le_int32(in, &(out->unknown_r));
	
	read_le_int32(in, &(out->total_b));

	read_le_int32(in, &(out->unknown_s));
	read_le_int32(in, &(out->unknown_t));
	read_le_int32(in, &(out->unknown_u));
	read_le_int32(in, &(out->unknown_v));
	read_le_int32(in, &(out->unknown_w));

	out->unknown_x = (unsigned char)fgetc(in);

	fread(out->end_marker, 1, 8, in);

	fread(dummy, 1, 82, in);

}

static int open_v4_temp3(char *path, DAO_INFO *out)
{
	int i,j,n,w;
	
	short session, track;
	int offset_comp;
	int previous_session_last;
	
	V4_TEMP3_TRACK work;
	
	FILE *stream;

	char junk[11];

	static const unsigned char marker[] = {
		0, 0, 1, 0, 0, 0, 255, 255, 255, 255,
		0, 0, 1, 0, 0, 0, 255, 255, 255, 255,
	};

	memset(out, 0, sizeof(DAO_INFO));
	memset(&work, 0, sizeof(V4_TEMP3_TRACK));

	stream = fopen(path, "rb");
	if(stream == NULL){
		return 0;
	}

	fseek(stream, -4, SEEK_END);
	read_le_int32(stream, &n);
	fseek(stream, n, SEEK_SET);

	read_le_int16(stream, &session);
	if (0 == session || session >= 100){
		fclose(stream);
		return 0;
	}

	out->path = path;
	out->num_of_track = 0;
	
	offset_comp = 0;
	previous_session_last = 0;
	for(i=0;i<session;i++){
		read_le_int16(stream, &track);
		read_le_int32(stream, &w);
		for(j=0;j<track;j++){
			read_v4_temp3_track(stream, &work);
			if(memcmp(work.marker, marker, 20)){
				fclose(stream);
				return 0;
			}
			n = out->num_of_track;
			out->num_of_track += 1;
			out->track[n].index = n;
			strcpy(out->track[n].path, path);

			switch(work.mode){
			case 0:
				out->track[n].type = DAO_TRACK_TYPE_AUDIO;
				break;
			case 1:
				out->track[n].type = DAO_TRACK_TYPE_MODE1;
				break;
			case 2:
				out->track[n].type = DAO_TRACK_TYPE_MODE2;
				break;
			default:
				fclose(stream);
				return 0;
			}

			switch(work.block_size){
			case 0:
				out->track[n].block_size = 2048;
				break;
			case 1:
				out->track[n].block_size = 2336;
				break;
			case 2:
				out->track[n].block_size = 2352;
				break;
			case 4:
				out->track[n].block_size = 2448;
				break;
			default:
				fclose(stream);
				return 0;
			}

			if(j == 0){
				offset_comp += (work.start - previous_session_last) * 2352;
			}
			out->track[n].offset = work.start * 2352 + work.pregap * out->track[n].block_size - offset_comp;

			out->track[n].start = work.start + work.pregap - 150;
			
			out->track[n].num_of_block = work.length;
			
			offset_comp += (int)((2352 - out->track[n].block_size) * work.total);

			if(work.total != work.total_b || !work.total){
				fclose(stream);
				return 0;
			}
		}
		previous_session_last = work.start + work.total;
		fread(junk, 1, 9, stream);
	}

	fclose(stream);

	return 1;
}

static void read_v4_temp3_track(FILE *in, V4_TEMP3_TRACK *out)
{
	int temp;
	char dummy[82];
	fread(dummy, 1, 8, in);
	fread(out->marker, 1, 20, in);

	fread(dummy, 1, 4, in);

	out->filename_length = (unsigned char)fgetc(in);
	fread(out->filename, 1, out->filename_length, in);

	temp = fgetc(in);
	read_le_int32(in, &(temp));	
	read_le_int32(in, &(temp));	
	read_le_int32(in, &(temp));	
	read_le_int32(in, &(temp));	
	read_le_int32(in, &(temp));	
	read_le_int32(in, &(temp));	

	read_le_int32(in, &(out->pregap));
	read_le_int32(in, &(out->length));

	read_le_int32(in, &(out->unknown_j));

	read_le_int16(in, &(out->unknown_k));

	read_le_int32(in, &(out->mode));

	read_le_int32(in, &(out->unknown_l));
	read_le_int32(in, &(out->unknown_m));

	read_le_int32(in, &(out->track));
	read_le_int32(in, &(out->start));
	read_le_int32(in, &(out->total));

	read_le_int32(in, &(out->unknown_n));
	read_le_int32(in, &(out->unknown_o));
	read_le_int32(in, &(out->unknown_p));
	read_le_int32(in, &(out->unknown_q));
	
	read_le_int32(in, &(out->block_size));

	out->control = (unsigned char)fgetc(in);

	read_le_int32(in, &(out->unknown_r));
	
	read_le_int32(in, &(out->total_b));

	read_le_int32(in, &(out->unknown_s));
	read_le_int32(in, &(out->unknown_t));
	read_le_int32(in, &(out->unknown_u));
	read_le_int32(in, &(out->unknown_v));
	read_le_int32(in, &(out->unknown_w));

	out->unknown_x = (unsigned char)fgetc(in);

	fread(out->end_marker, 1, 8, in);

	fread(dummy, 1, 82, in);

}
