#ifndef BINARY_H
#define BINARY_H

#include <stdio.h>

#ifdef  __cplusplus
extern "C" {
#endif

#ifndef BINARY_C
extern int read_le_int16(FILE *in, short *out);
extern int read_le_int32(FILE *in, int *out);
extern int write_le_int16(short in, FILE *out);
extern int write_le_int32(int in, FILE *out);

extern int read_be_int16(FILE *in, short *out);
extern int read_be_int32(FILE *in, int *out);
extern int write_be_int16(short in, FILE *out);
extern int write_be_int32(int in, FILE *out);

extern int le_char_array_to_int32(char *in);
extern short le_char_array_to_int16(char *in);
extern void int32_to_le_char_array(int in, char *out);
extern void int16_to_le_char_array(short in, char *out);

extern int be_char_array_to_int32(char *in);
extern short be_char_array_to_int16(char *in);
extern void int32_to_be_char_array(int in, char *out);
extern void int16_to_be_char_array(short in, char *out);
	
extern int binary_to_4bit_decimal(unsigned char hex);

extern void print_bit(int data, int column, FILE *out);

extern void file_skip(FILE *stream, size_t skip_size);

extern size_t get_filesize(char *filepath);	
#endif

#ifdef  __cplusplus
}
#endif

#endif
