#ifndef DATABASE_H
#define DATABASE_H

#include "atltime.h"
#include <string>
#include <map>
#include <vector>

class GCMDatabase
{
public:
	struct DATA
	{
		std::string id, name, language, selling, price, genre, date, machine, remark;
		DATA(){}
		DATA(const std::string& in);
		const std::string GetString() const;
		const CTime GetTimeStamp()const;
	};
private:
	std::map<std::string, DATA> m_mapTable;
	std::vector<std::string> m_vecAllID;
	std::vector<std::string> m_vecComment;

	void AddDataToTable(const DATA& data);
public:
	bool IsExistData(const std::string& id) const;
	const DATA& GetData(const std::string& id) const;

	void LoadFile(const std::string& file_name, const std::string& machine);
	void LoadAllFile(const std::string& file_name);
	void SaveAllFile(const std::string& file_name) const;

	int GetNumber() const{return (int)m_mapTable.size();}
	const std::vector<std::string>& GetAllID() const {return m_vecAllID;}
};

#endif
