#include "Header.h"
#include "stdafx.h"
#include <sstream>
#include <fstream>
#include "Utility.h"
#include "Database.h"
#include<boost/tokenizer.hpp>

using namespace std;

GCMDatabase::DATA::DATA(const string& in)
{
	istringstream iss(in);
	getline(iss, id, ',');
	getline(iss, name, ',');
	getline(iss, language, ',');
	getline(iss, selling, ',');
	getline(iss, price, ',');
	getline(iss, genre, ',');
	getline(iss, date, ',');
	getline(iss, machine, ',');
	getline(iss, remark, ',');
}

const string GCMDatabase::DATA::GetString() const
{
	return id + "," + name + "," + language + "," + selling + "," + price + "," + genre + "," + date + "," + machine + "," + remark + ",";
}

const CTime GCMDatabase::DATA::GetTimeStamp()const
{
	int y, m, d;
	if (date.size() == 6){
		y = GCMUtility::StringToInt(date.substr(0, 2));
		if (y >= 70){
			y += 1900;
		} else {
			y += 2000;
		}
		m = GCMUtility::StringToInt(date.substr(2, 2));
		d = GCMUtility::StringToInt(date.substr(4, 2));
	} else if (date.size() == 8){
		y = GCMUtility::StringToInt(date.substr(0, 4));
		m = GCMUtility::StringToInt(date.substr(4, 2));
		d = GCMUtility::StringToInt(date.substr(6, 2));
	} else {
		y = 2000;
		m = 1;
		d = 1;
	}
	return CTime(y, m, d, 0, 0, 0);
}

void GCMDatabase::AddDataToTable(const DATA& data)
{
	m_vecAllID.push_back(data.id);
	m_mapTable.insert(make_pair(data.id, data));
}

bool GCMDatabase::IsExistData(const string& id) const
{
	return m_mapTable.find(id) != m_mapTable.end();
}

const GCMDatabase::DATA& GCMDatabase::GetData(const string& id) const
{
	return m_mapTable.find(id)->second;
}

void GCMDatabase::LoadFile(const string& file_name, const string& machine)
{
	ifstream ifs;
	ifs.open(file_name.c_str());
	string machine_temp("," + machine + ",");

	string in;
	while (getline(ifs, in)){
		if (in[0] == ';'){
			m_vecComment.push_back(in);
		} else if (in.find(machine_temp) != string::npos){
			string data1 = in.substr(0, in.find(","));
			string data2 = in.substr(in.find(","));
			boost::tokenizer<> tok(data1);
			boost::tokenizer<>::iterator iter = tok.begin();
			while (iter != tok.end()){
				AddDataToTable(DATA(*iter++ + data2));
			}
		}
	}
}

void GCMDatabase::LoadAllFile(const string& file_name)
{
	ifstream ifs;
	ifs.open(file_name.c_str());

	string in;
	while (getline(ifs, in)){
		if (in[0] == ';'){
			m_vecComment.push_back(in);
			continue;
		}
		AddDataToTable(DATA(in));
	}
}

void GCMDatabase::SaveAllFile(const string& file_name) const
{
	ofstream ofs;
	ofs.open(file_name.c_str());

	vector<string>::const_iterator iter_c = m_vecComment.begin();
	while (iter_c != m_vecComment.end()){
		ofs << *iter_c++ << endl;
	}

	map<string, DATA>::const_iterator iter = m_mapTable.begin();
	while (iter != m_mapTable.end()){
		ofs << (iter++)->second.GetString() << endl;
	}
}
