#ifndef CONTROL_H
#define CONTROL_H

#include <string>
#include <vector>

class GCMControl;
class CGCM_RenamerDlg;

struct GCMConfigStructControl
{
	GCMConfigStructControl(){
		m_pRenamerDlg = 0;
		m_pControl = 0;
	}
	CGCM_RenamerDlg *m_pRenamerDlg;
	GCMControl* m_pControl;
	std::vector<std::string> m_vecEdit;
	std::vector<int> m_vecCheckBox;
	std::string m_strDaemonDrive;
	int m_iMachine;
};

struct GCMConfigStructResult
{
	std::string m_strMessageBox;
	std::string m_strStateText;
};

class GCMControl
{
private:
	GCMConfigStructControl m_Config;
	int GetCheckBox(int n)const;

	const std::string& GetEditWindowText(int n)const;

	static const std::string MachineNameNGC;
	static const std::string MachineNameGBA;
	static const std::string MachineNamePS;
	static const std::string MachineNamePS2;
	static const std::string MachineNameDC;
	static const std::string MachineNameN64;
	static const std::string MachineNameSNES;
	static const std::string MachineNameNES;
	static const std::string MachineNameFDS;
	static const std::string MachineNameSS;
	static const std::string MachineNameMEGACD;
	static const std::string MachineNameNEOGEOCD;
	static const std::string MachineNameNEOGEO;
	static const std::string MachineNamePCECD;
	static const std::string MachineNameWS;
	static const std::string MachineNameUNKNOWN;

	std::vector<std::string> m_vecFile;
	void FileFinder(const std::string& folder_name);

	enum MODE{
		MODE_UNKNOWN,
		MODE_NGC,
		MODE_GBA,
		MODE_PS,
		MODE_PS2,
		MODE_DC,
		MODE_N64,
		MODE_SNES,
		MODE_NES,
		MODE_FDS,
		MODE_SS,
		MODE_MEGACD,
		MODE_NEOGEOCD,
		MODE_NEOGEO,
		MODE_PCECD,
		MODE_WS
	};
	MODE GetMode() const;
	const std::string& GetModeName() const;

	bool m_bStop;
	bool m_bFinish;
public:
	GCMControl();
	void Rename(const GCMConfigStructControl& config);
	void GenerateList(const GCMConfigStructControl& config);
	void Stop(){m_bStop = true;}
	bool GetFinish()const{return m_bFinish;}
};

#endif
