#include "Header.h"
#include "stdafx.h"
#include <algorithm>
#include <sstream>
#include <fstream>
#include <memory>
#include "GCM_RenamerDlg.h"
#include "HaveList.h"
#include "File.h"
#include "FileNameForm.h"
#include "OutputText.h"
#include "Utility.h"
#include "ConfigFile.h"
#include "Control.h"

using namespace std;

const string GCMControl::MachineNameNGC("NGC");
const string GCMControl::MachineNameGBA("GBA");
const string GCMControl::MachineNamePS("PS");
const string GCMControl::MachineNamePS2("PS2");
const string GCMControl::MachineNameDC("DC");
const string GCMControl::MachineNameN64("N64");
const string GCMControl::MachineNameSNES("SNES");
const string GCMControl::MachineNameNES("NES");
const string GCMControl::MachineNameFDS("FDS");
const string GCMControl::MachineNameSS("SS");
const string GCMControl::MachineNameMEGACD("MEGACD");
const string GCMControl::MachineNameNEOGEOCD("NEOGEOCD");
const string GCMControl::MachineNameNEOGEO("NEOGEO");
const string GCMControl::MachineNamePCECD("PCECD");
const string GCMControl::MachineNameWS("WS");
const string GCMControl::MachineNameUNKNOWN("");

GCMControl::GCMControl()
{
	m_bFinish = false;
}

int GCMControl::GetCheckBox(int n) const
{
	return m_Config.m_vecCheckBox[n];
}

const string& GCMControl::GetEditWindowText(int n) const
{
	return m_Config.m_vecEdit[n];
}

void GCMControl::Rename(const GCMConfigStructControl& config)
{
	m_bStop = false;
	m_Config = config;
	m_Config.m_pRenamerDlg->SetProgressBarPosition(0);
	m_Config.m_pRenamerDlg->m_pCD->Restore();

	m_Config.m_pRenamerDlg->ChangeEnableWindow(FALSE);

	//tH_
	string folder(GetEditWindowText(0));
	if (!GCMUtility::IsFolder(folder)){
		string text = m_Config.m_pRenamerDlg->GetLanguage().Get("MessageBox", "FOLDER_NOT_FOUND");
		AfxMessageBox(text.c_str(), MB_OK | MB_SYSTEMMODAL | MB_ICONEXCLAMATION, 0);
		m_Config.m_pRenamerDlg->ChangeEnableWindow(TRUE);
		return;
	}
	//f[^x[Xt@C
	string database_file(GetEditWindowText(2));
	if (!GCMUtility::IsFile(database_file)){
		string text = m_Config.m_pRenamerDlg->GetLanguage().Get("MessageBox", "DATABASE_NOT_FOUND");
		AfxMessageBox(text.c_str(), MB_OK | MB_SYSTEMMODAL | MB_ICONINFORMATION, 0);
		m_Config.m_pRenamerDlg->ChangeEnableWindow(TRUE);
		return;
	}
	MODE rename_mode;
	if ((rename_mode = GetMode()) == MODE_UNKNOWN){
		string text = m_Config.m_pRenamerDlg->GetLanguage().Get("MessageBox", "MODE_NOT_SELECTED");
		AfxMessageBox(text.c_str(), MB_OK | MB_SYSTEMMODAL | MB_ICONINFORMATION, 0);
		m_Config.m_pRenamerDlg->ChangeEnableWindow(TRUE);
		return;
	}
	string machine(GetModeName());

	//t@C̗
	{
		string text = m_Config.m_pRenamerDlg->GetLanguage().Get("State", "FILE_ENUMERATION");
		m_Config.m_pRenamerDlg->SetStateText(text.c_str());
	}
	m_vecFile.clear();
	FileFinder(folder + "\\*.*");
	vector<string>::iterator iter_extention = m_vecFile.begin();
	while (iter_extention != m_vecFile.end()){
		iter_extention->erase(iter_extention->find_last_of('.'));
		++iter_extention;
	}
	m_vecFile.erase(unique(m_vecFile.begin(), m_vecFile.end()), m_vecFile.end());

	//f[^x[X̓ǂݍ
	{
		string text = m_Config.m_pRenamerDlg->GetLanguage().Get("State", "READ_DATABASE");
		m_Config.m_pRenamerDlg->SetStateText(text.c_str());
	}
	//GCMStopWatch watch;
	//watch.Start();
	GCMDatabase database;
	database.LoadFile(database_file, machine);
	//watch.Stop();

	//Xg̓ǂݍ
	{
		string text = m_Config.m_pRenamerDlg->GetLanguage().Get("State", "HAVE_LIST_READ");
		m_Config.m_pRenamerDlg->SetStateText(text.c_str());
	}
	GCMHaveList have;
	have.Load(machine);

	//t@CŜCRC
	bool whole_crc;
	if (GetCheckBox(2) == BST_CHECKED){
		whole_crc = true;
	} else {
		whole_crc = false;
	}

	//l[
	string daemon, drive;
	if (GetMode() == MODE_PS || GetMode() == MODE_PS2 || GetMode() == MODE_DC || GetMode() == MODE_NEOGEOCD){
		daemon = GetEditWindowText(4);
		drive = m_Config.m_strDaemonDrive;
	}
	int success = 0;
	int progress = 0;

	GCMConfigStructRename config_rename;
	config_rename.m_bFileCrc = whole_crc;
	config_rename.m_strDaemon = daemon;
	config_rename.m_strDrive = drive;
	if (GetCheckBox(4) == BST_CHECKED){
		config_rename.m_bArchiver = true;
	} else {
		config_rename.m_bArchiver = false;
	}
	config_rename.m_hWnd = m_Config.m_pRenamerDlg->GetSafeHwnd();

	//
	GCMConfigStructLetterWidth config_letter_width;
	if (GetCheckBox(5) == BST_CHECKED){
		config_letter_width.katakata = true;
	}
	if (GetCheckBox(6) == BST_CHECKED){
		config_letter_width.digit = true;
	}
	if (GetCheckBox(7) == BST_CHECKED){
		config_letter_width.alpha = true;
	}
	if (GetCheckBox(8) == BST_CHECKED){
		config_letter_width.space = true;
	}
	if (GetCheckBox(9) == BST_CHECKED){
		config_letter_width.mark = true;
	}
	GCMFileNameForm form(GetEditWindowText(1), config_letter_width);

	//l[ݒ
	GCMConfigStructFile config_file;
	if (GetCheckBox(10) == BST_CHECKED){
		config_file.m_bChangeTimestamp = true;
	} else {
		config_file.m_bChangeTimestamp = false;
	}

	//l[ob`
	GCMRenameBatch rename_batch;

	//O
	GCMOutputText log_file("log.txt");

	vector<string>::iterator iter = m_vecFile.begin();
	GCMFolderRenamer folder_renamer(folder, config_file.m_bChangeTimestamp);
	while (iter != m_vecFile.end() && !m_bStop){
		config_rename.m_strFileTitle = *iter++;
		log_file.Insert("l[Jn : " + config_rename.m_strFileTitle);
		{
			string text = m_Config.m_pRenamerDlg->GetLanguage().Get("State", "GET_ID");
			m_Config.m_pRenamerDlg->SetStateText(string(text + " : " + config_rename.m_strFileTitle));
		}
		auto_ptr<GCMFileBase> pfile;
		//ŃNX
		switch (GetMode()){
			case MODE_NGC:
				pfile = auto_ptr<GCMFileBase>(new GCMFileGCM(config_rename));
				break;
			case MODE_GBA:
				pfile = auto_ptr<GCMFileBase>(new GCMFileGBA(config_rename));
				break;
			case MODE_PS:
				pfile = auto_ptr<GCMFileBase>(new GCMFilePS(config_rename));
				break;
			case MODE_PS2:
				pfile = auto_ptr<GCMFileBase>(new GCMFilePS2(config_rename));
				break;
			case MODE_DC:
				pfile = auto_ptr<GCMFileBase>(new GCMFileDC(config_rename));
				break;
			case MODE_N64:
				pfile = auto_ptr<GCMFileBase>(new GCMFileN64(config_rename));
				break;
			case MODE_SNES:
				pfile = auto_ptr<GCMFileBase>(new GCMFileSNES(config_rename));
				break;
			case MODE_NES:
				pfile = auto_ptr<GCMFileBase>(new GCMFileNES(config_rename));
				break;
			case MODE_FDS:
				pfile = auto_ptr<GCMFileBase>(new GCMFileFDS(config_rename));
				break;
			case MODE_SS:
				pfile = auto_ptr<GCMFileBase>(new GCMFileSS(config_rename));
				break;
			case MODE_MEGACD:
				pfile = auto_ptr<GCMFileBase>(new GCMFileMEGACD(config_rename));
				break;
			case MODE_NEOGEOCD:
				pfile = auto_ptr<GCMFileBase>(new GCMFileNEOGEOCD(config_rename));
				break;
			case MODE_NEOGEO:
				pfile = auto_ptr<GCMFileBase>(new GCMFileNEOGEO(config_rename));
				break;
			case MODE_PCECD:
				pfile = auto_ptr<GCMFileBase>(new GCMFilePCECD(config_rename));
				break;
			case MODE_WS:
				pfile = auto_ptr<GCMFileBase>(new GCMFileWS(config_rename));
				break;
			default:
				break;
		}

		//isix\
		m_Config.m_pRenamerDlg->SetProgressBarPosition((++progress * CGCM_RenamerDlg::ProgressMax) / (int)m_vecFile.size());

		if (!pfile->IsOpend()){
			log_file.Insert("s - ID̎擾Ɏs܂");
			continue;
		}

		{
			string text = m_Config.m_pRenamerDlg->GetLanguage().Get("State", "RENAME");
			m_Config.m_pRenamerDlg->SetStateText(string(text + " : " + config_rename.m_strFileTitle));
		}
		string id;
		bool found = false;
		for (int i = 0; i < pfile->GetNumberOfID(); ++i){
			if (database.IsExistData(id = pfile->GetID(i))){
				found = true;
				break;
			}
		}
		if (found){
			GCMDatabase::DATA data = database.GetData(id);
			config_file.m_strRenamed = form.GetFormedFileName(data, config_rename.m_strFileTitle);
			log_file.Insert(" - ID : " + id + "  t@C^Cg : " + config_file.m_strRenamed);
			if (config_file.m_bChangeTimestamp){
				config_file.m_TimeStamp = data.GetTimeStamp();
			}
			rename_batch.Insert(pfile->GetFileTitle(), config_file.m_strRenamed);
			if (pfile->Rename(config_file)){
				++success;
				have.Insert(id);
				if (GetCheckBox(1) == BST_CHECKED){
					folder_renamer.SetTask(pfile->GetFileTitle(), config_file.m_strRenamed, config_file.m_TimeStamp);
				}
			}
		}
	}
	folder_renamer.StartRename();

	have.Save(database, machine);
	if (GetCheckBox(11) == BST_CHECKED){
		rename_batch.Output();
	}
	log_file.Output();

	int n = (int)m_vecFile.size();
	ostringstream oss;
	{
		string text = m_Config.m_pRenamerDlg->GetLanguage().Get("MessageBox", "DONE_1");
		oss << text << ":" << n << " ";
	}
	{
		string text = m_Config.m_pRenamerDlg->GetLanguage().Get("MessageBox", "DONE_2");
		oss << text << ":" << success << " ";
	}
	{
		string text = m_Config.m_pRenamerDlg->GetLanguage().Get("MessageBox", "DONE_3");
		oss << text << ":" << n - success;
	}

	{
		string text = m_Config.m_pRenamerDlg->GetLanguage().Get("MessageBox", "DONE_4");
		m_Config.m_pRenamerDlg->SetStateText(text + "  " + oss.str());
	}

	AfxMessageBox(oss.str().c_str(), MB_OK | MB_SYSTEMMODAL | MB_ICONINFORMATION);

	m_Config.m_pRenamerDlg->SetProgressBarPosition(0);

	m_Config.m_pRenamerDlg->ChangeEnableWindow(TRUE);
	m_bFinish = true;
}

void GCMControl::FileFinder(const std::string& folder_name)
{
	CFileFind finder;
	BOOL working = finder.FindFile(folder_name.c_str());

	while (working){
		working = finder.FindNextFile();
		
		if (finder.IsDots())
			continue;

		if (finder.IsDirectory()){
			if (GetCheckBox(0) == BST_UNCHECKED){
				continue;
			}
			std::string next_folder_name = (LPCTSTR)finder.GetFilePath();
			next_folder_name += "\\*.*";
			FileFinder(next_folder_name);
			continue;
		}

		std::string temp_file_name = (LPCTSTR)finder.GetFilePath();
		m_vecFile.push_back(temp_file_name);
	}
    finder.Close();
}

GCMControl::MODE GCMControl::GetMode() const
{
	int index = m_Config.m_pRenamerDlg->GetMachineNumber();
	switch (index){
		case 0:
            return MODE_NGC;
		case 1:
			return MODE_GBA;
		case 2:
			return MODE_PS;
		case 3:
			return MODE_PS2;
		case 4:
			return MODE_DC;
		case 5:
			return MODE_N64;
		case 6:
			return MODE_SNES;
		case 7:
			return MODE_NES;
		case 8:
			return MODE_FDS;
		case 9:
			return MODE_SS;
		case 10:
			return MODE_MEGACD;
		case 11:
			return MODE_NEOGEOCD;
		case 12:
			return MODE_NEOGEO;
		case 13:
			return MODE_PCECD;
		case 14:
			return MODE_WS;
		default:
			return MODE_UNKNOWN;
	}
}

const string& GCMControl::GetModeName() const
{
	switch (GetMode()){
		case MODE_NGC:
			return MachineNameNGC;
		case MODE_GBA:
			return MachineNameGBA;
		case MODE_PS:
			return MachineNamePS;
		case MODE_PS2:
			return MachineNamePS2;
		case MODE_DC:
			return MachineNameDC;
		case MODE_N64:
			return MachineNameN64;
		case MODE_SNES:
			return MachineNameSNES;
		case MODE_NES:
			return MachineNameNES;
		case MODE_FDS:
			return MachineNameFDS;
		case MODE_SS:
			return MachineNameSS;
		case MODE_MEGACD:
			return MachineNameMEGACD;
		case MODE_NEOGEOCD:
			return MachineNameNEOGEOCD;
		case MODE_NEOGEO:
			return MachineNameNEOGEO;
		case MODE_PCECD:
			return MachineNamePCECD;
		case MODE_WS:
			return MachineNameWS;
		default:
			return MachineNameUNKNOWN;
	}
}

void GCMControl::GenerateList(const GCMConfigStructControl& config)
{
	m_bStop = false;
	m_Config = config;
	m_Config.m_pRenamerDlg->SetProgressBarPosition(0);
	m_Config.m_pRenamerDlg->m_pCD->Restore();

	m_Config.m_pRenamerDlg->ChangeEnableWindow(FALSE);

	//tH_
	string folder(GetEditWindowText(0));
	if (!GCMUtility::IsFolder(folder)){
		string text = m_Config.m_pRenamerDlg->GetLanguage().Get("MessageBox", "FOLDER_NOT_FOUND");
		AfxMessageBox(text.c_str(), MB_OK | MB_SYSTEMMODAL | MB_ICONEXCLAMATION, 0);
		m_Config.m_pRenamerDlg->ChangeEnableWindow(TRUE);
		return;
	}
	//f[^x[Xt@C
	string database_file(GetEditWindowText(2));
	ofstream ofs;
	ofs.open(database_file.c_str(), ios_base::out | ios_base::app);
	if (!ofs.is_open()){
		string text = m_Config.m_pRenamerDlg->GetLanguage().Get("MessageBox", "DATABASE_NOT_FOUND");
		AfxMessageBox(text.c_str(), MB_OK | MB_SYSTEMMODAL | MB_ICONINFORMATION, 0);
		m_Config.m_pRenamerDlg->ChangeEnableWindow(TRUE);
		return;
	}
	GCMDatabase database;

	MODE rename_mode;
	if ((rename_mode = GetMode()) == MODE_UNKNOWN){
		string text = m_Config.m_pRenamerDlg->GetLanguage().Get("MessageBox", "MODE_NOT_SELECTED");
		AfxMessageBox(text.c_str(), MB_OK | MB_SYSTEMMODAL | MB_ICONINFORMATION, 0);
		m_Config.m_pRenamerDlg->ChangeEnableWindow(TRUE);
		return;
	}
	string machine(GetModeName());

	//t@C̗
	{
		string text = m_Config.m_pRenamerDlg->GetLanguage().Get("State", "FILE_ENUMERATION");
		m_Config.m_pRenamerDlg->SetStateText(text.c_str());
	}
	m_vecFile.clear();
	FileFinder(folder + "\\*.*");
	vector<string>::iterator iter_extention = m_vecFile.begin();
	while (iter_extention != m_vecFile.end()){
		iter_extention->erase(iter_extention->find_last_of('.'));
		++iter_extention;
	}
	m_vecFile.erase(unique(m_vecFile.begin(), m_vecFile.end()), m_vecFile.end());

	//f[^x[X̓ǂݍ
	/*
	{
		string text = m_Config.m_pRenamerDlg->GetLanguage().Get("State", "READ_DATABASE");
		m_Config.m_pRenamerDlg->SetStateText(text.c_str());
	}
	GCMDatabase database;
	database.LoadFile(database_file, machine);
	*/

	//t@CŜCRC
	bool whole_crc = false;

	//l[
	string daemon, drive;
	if (GetMode() == MODE_PS || GetMode() == MODE_PS2 || GetMode() == MODE_DC || GetMode() == MODE_NEOGEOCD){
		daemon = GetEditWindowText(4);
		drive = m_Config.m_strDaemonDrive;
	}
	int progress = 0;

	GCMConfigStructRename config_rename;
	config_rename.m_bFileCrc = whole_crc;
	config_rename.m_strDaemon = daemon;
	config_rename.m_strDrive = drive;
	if (GetCheckBox(4) == BST_CHECKED){
		config_rename.m_bArchiver = true;
	} else {
		config_rename.m_bArchiver = false;
	}
	config_rename.m_hWnd = m_Config.m_pRenamerDlg->GetSafeHwnd();

	//
	/*
	GCMConfigStructLetterWidth config_letter_width;
	if (GetCheckBox(5) == BST_CHECKED){
		config_letter_width.katakata = true;
	}
	if (GetCheckBox(6) == BST_CHECKED){
		config_letter_width.digit = true;
	}
	if (GetCheckBox(7) == BST_CHECKED){
		config_letter_width.alpha = true;
	}
	if (GetCheckBox(8) == BST_CHECKED){
		config_letter_width.space = true;
	}
	if (GetCheckBox(9) == BST_CHECKED){
		config_letter_width.mark = true;
	}
	GCMFileNameForm form(GetEditWindowText(1), config_letter_width);
	*/

	//l[ݒ
	/*
	GCMConfigStructFile config_file;
	if (GetCheckBox(10) == BST_CHECKED){
		config_file.m_bChangeTimestamp = true;
	} else {
		config_file.m_bChangeTimestamp = false;
	}
	*/

	vector<string>::iterator iter = m_vecFile.begin();
	//GCMFolderRenamer folder_renamer(folder, config_file.m_bChangeTimestamp);
	while (iter != m_vecFile.end() && !m_bStop){
		config_rename.m_strFileTitle = *iter++;
		{
			string text = m_Config.m_pRenamerDlg->GetLanguage().Get("State", "GET_ID");
			m_Config.m_pRenamerDlg->SetStateText(string(text + " : " + config_rename.m_strFileTitle));
		}
		auto_ptr<GCMFileBase> pfile;
		//ŃNX
		switch (GetMode()){
			case MODE_NGC:
				pfile = auto_ptr<GCMFileBase>(new GCMFileGCM(config_rename));
				break;
			case MODE_GBA:
				pfile = auto_ptr<GCMFileBase>(new GCMFileGBA(config_rename));
				break;
			case MODE_PS:
				pfile = auto_ptr<GCMFileBase>(new GCMFilePS(config_rename));
				break;
			case MODE_PS2:
				pfile = auto_ptr<GCMFileBase>(new GCMFilePS2(config_rename));
				break;
			case MODE_DC:
				pfile = auto_ptr<GCMFileBase>(new GCMFileDC(config_rename));
				break;
			case MODE_N64:
				pfile = auto_ptr<GCMFileBase>(new GCMFileN64(config_rename));
				break;
			case MODE_SNES:
				pfile = auto_ptr<GCMFileBase>(new GCMFileSNES(config_rename));
				break;
			case MODE_NES:
				pfile = auto_ptr<GCMFileBase>(new GCMFileNES(config_rename));
				break;
			case MODE_FDS:
				pfile = auto_ptr<GCMFileBase>(new GCMFileFDS(config_rename));
				break;
			case MODE_SS:
				pfile = auto_ptr<GCMFileBase>(new GCMFileSS(config_rename));
				break;
			case MODE_MEGACD:
				pfile = auto_ptr<GCMFileBase>(new GCMFileMEGACD(config_rename));
				break;
			case MODE_NEOGEOCD:
				pfile = auto_ptr<GCMFileBase>(new GCMFileNEOGEOCD(config_rename));
				break;
			case MODE_NEOGEO:
				pfile = auto_ptr<GCMFileBase>(new GCMFileNEOGEO(config_rename));
				break;
			case MODE_PCECD:
				pfile = auto_ptr<GCMFileBase>(new GCMFilePCECD(config_rename));
				break;
			case MODE_WS:
				pfile = auto_ptr<GCMFileBase>(new GCMFileWS(config_rename));
				break;
			default:
				break;
		}

		//isix\
		m_Config.m_pRenamerDlg->SetProgressBarPosition((++progress * CGCM_RenamerDlg::ProgressMax) / (int)m_vecFile.size());

		if (!pfile->IsOpend()){
			continue;
		}

		GCMDatabase::DATA record;
		record.id = pfile->GetID(0);
		record.name = config_rename.m_strFileTitle;
		record.machine = GetModeName();
		ofs << record.GetString() << endl;
	}
	//folder_renamer.StartRename();

	//have.Save(database, machine);
	/*
	if (GetCheckBox(11) == BST_CHECKED){
		rename_batch.MakeBatchFile();
	}
	*/

	//int n = (int)m_vecFile.size();
	{
		string text = m_Config.m_pRenamerDlg->GetLanguage().Get("MessageBox", "LIST_DONE_1");
		m_Config.m_pRenamerDlg->SetStateText(text);
		AfxMessageBox(text.c_str(), MB_OK | MB_SYSTEMMODAL | MB_ICONINFORMATION);
	}


	m_Config.m_pRenamerDlg->SetProgressBarPosition(0);

	m_Config.m_pRenamerDlg->ChangeEnableWindow(TRUE);
	m_bFinish = true;
}
