#ifndef CONFIG_FILE_H
#define CONFIG_FILE_H

#include <map>
#include <string>

class GCMConfigFile
{
private:
	std::string m_strHeader;
	std::map<std::string, std::map<std::string, std::string> > m_mapData;
public:
	GCMConfigFile(const std::string& header) : m_strHeader(header){}
	GCMConfigFile(){}
	~GCMConfigFile(){}
	bool Load(const std::string& file_name);
	bool Save(const std::string& file_name)const;
	const std::string Get(const std::string& section, const std::string& key)const;
	void Set(const std::string& section, const std::string& key, const std::string& value);
	void SetHeader(const std::string& header){
		m_strHeader = header;
	}
};

#endif
