#include "Header.h"
#include <fstream>
#include <sstream>
#include "ConfigFile.h"

using namespace std;

bool GCMConfigFile::Load(const string& file_name)
{
	ifstream ifs;
	ifs.open(file_name.c_str());
	if (!ifs.is_open()){
		return false;
	}
	string header;
	getline(ifs, header);
	if (m_strHeader != header){
		return false;
	}
	string line;
	string section;
	while (getline(ifs, line)){
		if (line.empty()){
			continue;
		}
		if (line[0] == '[' && line[line.size() - 1] == ']'){
			section = line.substr(1, line.size() - 2);
			continue;
		}
		if (line.find('=') == string::npos){
			continue;
		}
		string key, value;
		istringstream iss(line);
		getline(iss, key, '=');
		getline(iss, value);
		Set(section, key, value);
	}
	return true;
}

bool GCMConfigFile::Save(const string& file_name)const
{
	ofstream ofs;
	ofs.open(file_name.c_str());
	if (!ofs.is_open()){
		return false;
	}
	ofs << m_strHeader << endl;
	map<string, map<string, string> >::const_iterator i_section = m_mapData.begin();
	while (i_section != m_mapData.end()){
		ofs << "[" << i_section->first << "]" << endl;
		map<string, string>::const_iterator i_key = i_section->second.begin();
		while (i_key != i_section->second.end()){
			ofs << i_key->first << "=" << i_key->second << endl;
			++i_key;
		}
		++i_section;
	}
	return true;
}

const string GCMConfigFile::Get(const string& section, const string& key)const
{
	map<string, map<string, string> >::const_iterator i_section = m_mapData.find(section);
	if (i_section == m_mapData.end()){
		return "";
	}
	map<string, string>::const_iterator i_key = i_section->second.find(key);
	if (i_key == i_section->second.end()){
		return "";
	}
	return i_key->second;
}

void GCMConfigFile::Set(const string& section, const string& key, const string& value)
{
	m_mapData[section][key] = value;
}
