#ifndef CDIMAGE_H
#define CDIMAGE_H

#include <string>

struct DAO_INFO;
struct ISO_INFO;

enum TRACK_TYPE{
	TRACK_MODE1,
	TRACK_MODE2XA,
	TRACK_AUDIO,
	TRACK_UNKNOWN
};

class GCMCDImageBase
{
protected:
	std::string m_strFilePath;
	bool m_bIsOpen;
public:
	virtual ~GCMCDImageBase(){}
	const std::string& GetFilePath()const{return m_strFilePath;}
	bool IsOpen()const{return m_bIsOpen;}

	virtual int GetNumberOfTrack()const = 0;
	virtual int GetOffset(int track)const = 0;
	virtual int GetBlockSize(int track)const = 0;
	virtual int GetTrackType(int track)const = 0;
	virtual const std::string GetTrackFilePath(int track)const = 0;
};

class GCMCDImageDAO : public GCMCDImageBase
{
private:
	std::auto_ptr<DAO_INFO> m_pDAOInfo;
public:
	GCMCDImageDAO(const std::string& file_name);
	virtual ~GCMCDImageDAO();

	virtual int GetNumberOfTrack()const;
	virtual int GetOffset(int track)const;
	virtual int GetBlockSize(int track)const;
	virtual int GetTrackType(int track)const;
	virtual const std::string GetTrackFilePath(int track)const;
};

class GCMCDImageISO : public GCMCDImageBase
{
private:
	std::auto_ptr<ISO_INFO> m_pISOInfo;
public:
	GCMCDImageISO(const std::string& file_name);
	virtual ~GCMCDImageISO();

	virtual int GetNumberOfTrack()const;
	virtual int GetOffset(int track)const;
	virtual int GetBlockSize(int track)const;
	virtual int GetTrackType(int track)const;
	virtual const std::string GetTrackFilePath(int track)const;
};

class GCMCDImage
{
private:
	std::auto_ptr<GCMCDImageBase> m_pCDImage;
	bool m_bIsOpen;
public:
	GCMCDImage(const std::string& file_name);
	virtual ~GCMCDImage();
	bool IsOpen()const{return m_bIsOpen;}
	int GetNumberOfTrack()const{return m_pCDImage->GetNumberOfTrack();}
	int GetOffset(int track)const{return m_pCDImage->GetOffset(track);}
	int GetBlockSize(int track)const{return m_pCDImage->GetBlockSize(track);}
	int GetSectorOffset(int track)const;
	int GetTrackType(int track)const{return m_pCDImage->GetTrackType(track);}
	const std::string& GetFilePath()const{return m_pCDImage->GetFilePath();}
	const std::string GetTrackFilePath(int track)const{return m_pCDImage->GetTrackFilePath(track);}

	bool GetDataToMemory(char* pointer, int track, int sector, int sector_count);
};

#endif
