#include "Header.h"
#include "stdafx.h"
#include "Header.h"
#include <memory>
#include "Utility.h"
#include "CDImage.h"
#include ".\FCDUtil\ccd.h"
#include ".\FCDUtil\cdi.h"
#include ".\FCDUtil\cue.h"
#include ".\FCDUtil\iso_xa.h"
#include ".\FCDUtil\nrg.h"

using namespace std;

//cueEccdEcdiEnrgt@C
GCMCDImageDAO::GCMCDImageDAO(const string& file_name)
{
	m_bIsOpen = false;
	m_pDAOInfo = auto_ptr<DAO_INFO>(new DAO_INFO);
	ZeroMemory(m_pDAOInfo.get(), sizeof(DAO_INFO));
	auto_ptr<char> temp_file_name = auto_ptr<char>(new char[file_name.size() + 1]);
	ZeroMemory(temp_file_name.get(), file_name.size() + 1);
	strcpy(temp_file_name.get(), file_name.c_str());
	if (GCMUtility::ToLower(file_name).find(".ccd") != string::npos){
		if (open_ccd_file(temp_file_name.get(), m_pDAOInfo.get())){
			m_strFilePath = m_pDAOInfo->path;
			m_bIsOpen = true;
			return;
		}
	} else if (GCMUtility::ToLower(file_name).find(".cdi") != string::npos){
		if (open_cdi_file(temp_file_name.get(), m_pDAOInfo.get())){
			m_strFilePath = m_pDAOInfo->path;
			m_bIsOpen = true;
			return;
		}
	} else if (GCMUtility::ToLower(file_name).find(".cue") != string::npos){
		if (open_cue_file(temp_file_name.get(), m_pDAOInfo.get())){
			m_strFilePath = m_pDAOInfo->path;
			m_bIsOpen = true;
			return;
		}
	} else if (GCMUtility::ToLower(file_name).find(".nrg") != string::npos){
		if (open_nrg_file(temp_file_name.get(), m_pDAOInfo.get())){
			m_strFilePath = m_pDAOInfo->path;
			m_bIsOpen = true;
			return;
		}
	}
}

GCMCDImageDAO::~GCMCDImageDAO()
{
}

int GCMCDImageDAO::GetNumberOfTrack()const
{
	return m_pDAOInfo->num_of_track;
}

int GCMCDImageDAO::GetOffset(int track)const
{
	if (track >= GetNumberOfTrack()){
		return 0;
	}
	return (int)m_pDAOInfo->track[track].offset;
}

int GCMCDImageDAO::GetBlockSize(int track)const
{
	if (track >= GetNumberOfTrack()){
		return 0;
	}
	return (int)m_pDAOInfo->track[track].block_size;
}

int GCMCDImageDAO::GetTrackType(int track)const
{
	if (track >= GetNumberOfTrack()){
		return 0;
	}
	int type = m_pDAOInfo->track[track].type;
	if (type == DAO_TRACK_TYPE_MODE1){
		return TRACK_MODE1;
	} else if (type == DAO_TRACK_TYPE_MODE2){
		return TRACK_MODE2XA;
	} else if(type == DAO_TRACK_TYPE_AUDIO){
		return TRACK_AUDIO;
	}
	return TRACK_UNKNOWN;
}

const string GCMCDImageDAO::GetTrackFilePath(int track)const
{
	if (track >= GetNumberOfTrack()){
		return "";
	}
	return m_pDAOInfo->track[track].path;
}

//ISOt@C
GCMCDImageISO::GCMCDImageISO(const string& file_name)
{
	m_pISOInfo = auto_ptr<ISO_INFO>(new ISO_INFO);
	ZeroMemory(m_pISOInfo.get(), sizeof(ISO_INFO));
	auto_ptr<char> temp_file_name = auto_ptr<char>(new char[file_name.size() + 1]);
	ZeroMemory(temp_file_name.get(), file_name.size() + 1);
	strcpy(temp_file_name.get(), file_name.c_str());
	if (::open_iso_file(temp_file_name.get(), m_pISOInfo.get())){
		::close_iso_file(m_pISOInfo.get());
		m_strFilePath = file_name;
		m_bIsOpen = true;
		return;
	}
}

GCMCDImageISO::~GCMCDImageISO()
{
}

int GCMCDImageISO::GetNumberOfTrack()const
{
	return 1;
}

int GCMCDImageISO::GetOffset(int track)const
{
	return 0;
}

int GCMCDImageISO::GetBlockSize(int track)const
{
	return (int)m_pISOInfo->block_size;
}

int GCMCDImageISO::GetTrackType(int track)const
{
	return (m_pISOInfo->mode == 1) ? TRACK_MODE1 : TRACK_MODE2XA;
}

const string GCMCDImageISO::GetTrackFilePath(int track)const
{
	if (track > 0){
		return "";
	}
	return m_strFilePath;
}

//C^[tF[X
GCMCDImage::GCMCDImage(const string& file_name)
{
	//_CrtSetDbgFlag( _CRTDBG_ALLOC_MEM_DF | _CRTDBG_LEAK_CHECK_DF);
	m_bIsOpen = false;
	m_pCDImage = auto_ptr<GCMCDImageBase>(new GCMCDImageDAO(file_name));
	if (m_pCDImage->IsOpen()){
		m_bIsOpen = true;
		return;
	}
	m_pCDImage = auto_ptr<GCMCDImageBase>(new GCMCDImageISO(file_name));
	if (m_pCDImage->IsOpen()){
		m_bIsOpen = true;
		return;
	}
}

GCMCDImage::~GCMCDImage()
{
}

int GCMCDImage::GetSectorOffset(int track)const{
	int res = 0;
	if (GetTrackType(track) == TRACK_MODE2XA){
		res = (GetBlockSize(track) == 2336) ? 8 : 24;
	}
	return res;
}

bool GCMCDImage::GetDataToMemory(char* pointer, int track, int sector, int sector_count)
{
	CFile file;
	if (!file.Open(m_pCDImage->GetFilePath().c_str(), CFile::modeRead | CFile::shareDenyWrite | CFile::osRandomAccess)){
		return false;
	}
	int track_offset = GetOffset(track);
	int block_size = GetBlockSize(track);
	int sector_offset = GetSectorOffset(track);
	for (int i = 0; i < sector_count; i++){
		file.Seek((sector + i) * block_size + track_offset + sector_offset, CFile::begin);
		file.Read(i * 2048 + pointer, 2048);
	}
	return true;
}
