#ifndef CDFILESYSTEM_H
#define CDFILESYSTEM_H

#include <boost/shared_ptr.hpp>
#include <string>
#include <vector>

class GCMCDImage;

class GCMCDFileSystem
{
public:
	struct FILE{//fBNgR[h
		std::string name;
		unsigned char data_size;
		bool is_directory, is_last_record, end;
		unsigned int lba_start, file_size;
		FILE(const char* pointer);
	};
private:
	//static const int PathTableCacheSize;
	struct DIRECTORY{//pXe[u
		std::string name;
		int data_size, record_size;
		unsigned int lba_start;
		unsigned short parent;
		DIRECTORY(const std::string& directory_name, unsigned int lba) : name(directory_name), lba_start(lba), parent(0), record_size(0){}
		DIRECTORY(const char* pointer);
		int GetPathTableSize()const;
	};
	class FindTargetDirectory;
	std::auto_ptr<GCMCDImage> m_pCDImage;
	bool m_bOpened;
	int m_iFileNumber;

	std::vector<DIRECTORY> m_vecPathTable;
	std::vector<FILE> m_vecFileTable;
	std::vector<boost::shared_ptr<char> > m_vecFilePointer;
	std::vector<unsigned int> m_vecFileSize;

	//void GetDataToMemory(char* pointer, int track, int sector, int sector_count);
	//std::auto_ptr<CFile> m_pFile;
public:
	GCMCDFileSystem(const std::string& file_name);
	virtual ~GCMCDFileSystem();
	bool IsOpen()const{return m_bOpened;}
	int FileOpen(const std::string& file_name);
	const char* GetFilePointer(int file_number)const;
	unsigned int GetFileSize(int file_number)const;
	const std::string GetFileCRC(const std::string& file_name);
};

#endif
