#ifndef ARCHIVER_H
#define ARCHIVER_H

#include <string>

struct GCMArchiverConfigStruct
{
	std::string archive, temp_folder;
	HWND hwnd;
};

class GCMArchiverBase
{
private:
	void DeleteFolderTree(const std::string& folder)const;
protected:
	HMODULE m_hModule;
	bool m_bIsOpened;
	std::string m_strArchive, m_strFolder;
	static const int LogBufferSize;
	HWND m_hWnd;
public:
	GCMArchiverBase(const GCMArchiverConfigStruct& config);
	virtual ~GCMArchiverBase();
	bool IsOpened() const {return m_bIsOpened;}
};

class GCMArchiverZIP : public GCMArchiverBase
{
public:
	GCMArchiverZIP(const GCMArchiverConfigStruct& config);
};

class GCMArchiverRAR : public GCMArchiverBase
{
public:
	GCMArchiverRAR(const GCMArchiverConfigStruct& config);
};

class GCMArchiver7Z : public GCMArchiverBase
{
public:
	GCMArchiver7Z(const GCMArchiverConfigStruct& config);
};

class GCMArchiverLZH : public GCMArchiverBase
{
public:
	GCMArchiverLZH(const GCMArchiverConfigStruct& config);
};

class GCMArchiverGCA : public GCMArchiverBase
{
public:
	GCMArchiverGCA(const GCMArchiverConfigStruct& config);
};

class GCMArchiverCAB : public GCMArchiverBase
{
public:
	GCMArchiverCAB(const GCMArchiverConfigStruct& config);
};

#endif
