#include "Header.h"
#include "stdafx.h"
#include <memory>
#include "shellapi.h"
#include "Archiver.h"

using namespace std;

//typedef UINT (CALLBACK* LPFNDLLFUNC1)(DWORD,UINT);
typedef int (CALLBACK* LPFUNC)(const HWND, LPCSTR, LPSTR, const DWORD);

const int GCMArchiverBase::LogBufferSize(1024);

GCMArchiverBase::GCMArchiverBase(const GCMArchiverConfigStruct& config)
{
	m_hModule = NULL;
	m_strArchive = config.archive;
	m_strFolder = config.temp_folder;
	m_hWnd = config.hwnd;
	DeleteFolderTree(m_strFolder);
	CreateDirectory(m_strFolder.c_str(), NULL);
}

GCMArchiverBase::~GCMArchiverBase()
{
	DeleteFolderTree(m_strFolder);
}

void GCMArchiverBase::DeleteFolderTree(const string& folder)const
{
	auto_ptr<char> folder_temp = auto_ptr<char>(new char[folder.size() + 2]);
	ZeroMemory(folder_temp.get(), folder.size() + 2);
	strcpy(folder_temp.get(), folder.c_str());
	SHFILEOPSTRUCT FileOp;
	FILEOP_FLAGS flag = FOF_NOCONFIRMATION|FOF_NOCONFIRMMKDIR|FOF_SILENT|FOF_NOERRORUI;
	ZeroMemory( &FileOp, sizeof(SHFILEOPSTRUCT) );
	FileOp.hwnd   = m_hWnd;        // sEChẼnh
	FileOp.wFunc  = FO_DELETE;     // Rs[w
	FileOp.pFrom  = folder_temp.get();   // NULLŏI[ꂽRs[tH_
	FileOp.fFlags = flag;        // _CAO͕\Ȃ
	SHFileOperation( &FileOp );
}

//ZIP
GCMArchiverZIP::GCMArchiverZIP(const GCMArchiverConfigStruct& config) : GCMArchiverBase(config)
{
	m_hModule = LoadLibrary("UNZIP32.DLL");
	if (m_hModule == NULL){
		return;
	}
	LPFUNC func = (LPFUNC)GetProcAddress(m_hModule, "UnZip");
	if (!func){
		FreeLibrary(m_hModule);
		m_hModule = NULL;
		return;
	}
	auto_ptr<char> log_buffer = auto_ptr<char>(new char[LogBufferSize + 1]);
	ZeroMemory(log_buffer.get(), LogBufferSize + 1);
	int res = func(config.hwnd, string("-x -j \"" + m_strArchive + "\" \"" + m_strFolder + "\\\"").c_str(), log_buffer.get(), LogBufferSize);
	FreeLibrary(m_hModule);
	m_hModule = NULL;
	if (res){
        string log_string(log_buffer.get());
		MessageBox(NULL, (LPCTSTR)log_string.c_str(), "Archive (ZIP) Error", MB_OK | MB_ICONINFORMATION );
		return;
	}
	m_bIsOpened = true;
}

//RAR
GCMArchiverRAR::GCMArchiverRAR(const GCMArchiverConfigStruct& config) : GCMArchiverBase(config)
{
	m_hModule = LoadLibrary("UNRAR32.DLL");
	if (m_hModule == NULL){
		return;
	}
	LPFUNC func = (LPFUNC)GetProcAddress(m_hModule, "Unrar");
	if (!func){
		FreeLibrary(m_hModule);
		m_hModule = NULL;
		return;
	}
	auto_ptr<char> log_buffer = auto_ptr<char>(new char[LogBufferSize + 1]);
	ZeroMemory(log_buffer.get(), LogBufferSize + 1);
	int res = func(config.hwnd, string("-e -y -o \"" + m_strArchive + "\" \"" + m_strFolder + "\\\"").c_str(), log_buffer.get(), LogBufferSize);
	FreeLibrary(m_hModule);
	m_hModule = NULL;
	if (res){
        string log_string(log_buffer.get());
		MessageBox(NULL, (LPCTSTR)log_string.c_str(), "Archive (RAR) Error", MB_OK | MB_ICONINFORMATION );
		return;
	}
	m_bIsOpened = true;
}

//7Z
GCMArchiver7Z::GCMArchiver7Z(const GCMArchiverConfigStruct& config) : GCMArchiverBase(config)
{
	m_hModule = LoadLibrary("7-ZIP32.DLL");
	if (m_hModule == NULL){
		return;
	}
	LPFUNC func = (LPFUNC)GetProcAddress(m_hModule, "SevenZip");
	if (!func){
		FreeLibrary(m_hModule);
		m_hModule = NULL;
		return;
	}
	auto_ptr<char> log_buffer = auto_ptr<char>(new char[LogBufferSize + 1]);
	ZeroMemory(log_buffer.get(), LogBufferSize + 1);
	int res = func(config.hwnd, string("e -aoa -y \"" + m_strArchive + "\" \"" + m_strFolder + "\\\"").c_str(), log_buffer.get(), LogBufferSize);
	FreeLibrary(m_hModule);
	m_hModule = NULL;
	if (res){
        string log_string(log_buffer.get());
		MessageBox(NULL, (LPCTSTR)log_string.c_str(), "Archive (7Z) Error", MB_OK | MB_ICONINFORMATION );
		return;
	}
	m_bIsOpened = true;
}

//LZH
GCMArchiverLZH::GCMArchiverLZH(const GCMArchiverConfigStruct& config) : GCMArchiverBase(config)
{
	m_hModule = LoadLibrary("UNLHA32.DLL");
	if (m_hModule == NULL){
		return;
	}
	LPFUNC func = (LPFUNC)GetProcAddress(m_hModule, "Unlha");
	if (!func){
		FreeLibrary(m_hModule);
		m_hModule = NULL;
		return;
	}
	auto_ptr<char> log_buffer = auto_ptr<char>(new char[LogBufferSize + 1]);
	ZeroMemory(log_buffer.get(), LogBufferSize + 1);
	int res = func(config.hwnd, string("e \"" + m_strArchive + "\" \"" + m_strFolder + "\\\"").c_str(), log_buffer.get(), LogBufferSize);
	FreeLibrary(m_hModule);
	m_hModule = NULL;
	if (res){
        string log_string(log_buffer.get());
		MessageBox(NULL, (LPCTSTR)log_string.c_str(), "Archive (LZH) Error", MB_OK | MB_ICONINFORMATION );
		return;
	}
	m_bIsOpened = true;
}

//GCA
GCMArchiverGCA::GCMArchiverGCA(const GCMArchiverConfigStruct& config) : GCMArchiverBase(config)
{
	m_hModule = LoadLibrary("UNGCA32.DLL");
	if (m_hModule == NULL){
		return;
	}
	LPFUNC func = (LPFUNC)GetProcAddress(m_hModule, "UnZip");
	if (!func){
		FreeLibrary(m_hModule);
		m_hModule = NULL;
		return;
	}
	auto_ptr<char> log_buffer = auto_ptr<char>(new char[LogBufferSize + 1]);
	ZeroMemory(log_buffer.get(), LogBufferSize + 1);
	int res = func(config.hwnd, string("-x -sx1 \"" + m_strArchive + "\" \"" + m_strFolder + "\\\"").c_str(), log_buffer.get(), LogBufferSize);
	FreeLibrary(m_hModule);
	m_hModule = NULL;
	if (res){
        string log_string(log_buffer.get());
		MessageBox(NULL, (LPCTSTR)log_string.c_str(), "Archive (CAB) Error", MB_OK | MB_ICONINFORMATION );
		return;
	}
	m_bIsOpened = true;
}

//CAB
GCMArchiverCAB::GCMArchiverCAB(const GCMArchiverConfigStruct& config) : GCMArchiverBase(config)
{
	m_hModule = LoadLibrary("CAB32.DLL");
	if (m_hModule == NULL){
		return;
	}
	LPFUNC func = (LPFUNC)GetProcAddress(m_hModule, "Cab");
	if (!func){
		FreeLibrary(m_hModule);
		m_hModule = NULL;
		return;
	}
	auto_ptr<char> log_buffer = auto_ptr<char>(new char[LogBufferSize + 1]);
	ZeroMemory(log_buffer.get(), LogBufferSize + 1);
	int res = func(config.hwnd, string("-x -j \"" + m_strArchive + "\" \"" + m_strFolder + "\\\"").c_str(), log_buffer.get(), LogBufferSize);
	FreeLibrary(m_hModule);
	m_hModule = NULL;
	if (res){
        string log_string(log_buffer.get());
		MessageBox(NULL, (LPCTSTR)log_string.c_str(), "Archive (Zip) Error", MB_OK | MB_ICONINFORMATION );
		return;
	}
	m_bIsOpened = true;
}

