#include "stdafx.h"
#include <algorithm>
#include <memory>
#include <boost/format.hpp>
#include "Control.h"
#include "Utility.h"
#include "NFilePSDK.h"
#include "NFileStdio.h"

#define USE_THREAD
//#undef USE_THREAD

using namespace std;

long long Control::iFileSizeTotal = 0;
long long Control::iFileSizeProgress = 0;
bool Control::m_bIsRunning = false;
std::vector<std::string> Control::vecFilePath;
CEmptyReadDlg* Control::m_pDialog = NULL;

void Control::SetDialog(CEmptyReadDlg& dlg)
{
	m_pDialog = &dlg;
}

void Control::Clear()
{
	vecFilePath.clear();
}

void Control::Add(const std::string& file_path)
{
	if (Utility::IsFile(file_path)){
		vecFilePath.push_back(file_path);
	} else if (Utility::IsFolder(file_path)){
		CFileFind finder;
		BOOL working = finder.FindFile((file_path + "\\*.*").c_str());
		while (working){
			working = finder.FindNextFile();
			if (finder.IsDots())
				continue;
			Add((LPCTSTR)finder.GetFilePath());
		}
		finder.Close();
	}
}

void Control::Start()
{
#ifdef USE_THREAD
	AfxBeginThread(StartTask, NULL);
#else
	StartTask(NULL);
#endif
}

int iBufferSize = Utility::GetClusterSize("");

UINT Control::StartTask(LPVOID param)
{
	m_pDialog->EnableWindow(false);
	iFileSizeTotal = iFileSizeProgress = 0;
	sort(vecFilePath.begin(), vecFilePath.end());
	for (vector<string>::iterator it = vecFilePath.begin(); it != vecFilePath.end(); ++it){
		iFileSizeTotal += Utility::GetFileSize(*it);
	}
	m_bIsRunning = true;
#ifdef USE_THREAD
	AfxBeginThread(Timer, NULL);
#endif
	auto_ptr<char> buffer(new char[iBufferSize]);
	for (vector<string>::iterator it = vecFilePath.begin(); it != vecFilePath.end(); ++it){
//		NFileStdio file(it->c_str(), "rbS");
		NFilePSDK file(*it, GENERIC_READ, FILE_SHARE_READ, OPEN_EXISTING, FILE_FLAG_SEQUENTIAL_SCAN);
//		NFilePSDK file(*it, GENERIC_READ, FILE_SHARE_READ, OPEN_EXISTING, FILE_FLAG_SEQUENTIAL_SCAN);
		if (!file.IsOpen()){
			continue;
		}
		int read_size;
		while ((read_size = file.Read(buffer.get(), iBufferSize)) != 0){
			iFileSizeProgress += read_size;
		}
	}
	m_bIsRunning = false;
#ifndef USE_THREAD
	m_pDialog->EnableWindow(true);
#endif
	Clear();
	return 0;
}

UINT Control::Timer(LPVOID param)
{
	while (m_bIsRunning){
		float f = (float)iFileSizeProgress / (float)iFileSizeTotal;
		m_pDialog->SetProgressBar(f);

		m_pDialog->SetStateText((boost::format("%1% / %2%") % iFileSizeProgress % iFileSizeTotal).str());
		
		Sleep(100);
	}
	m_pDialog->SetProgressBar(1.0f);
	m_pDialog->SetStateText("I");
	m_pDialog->EnableWindow(true);

	return 0;
}
